/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config;

import com.elitescloud.boot.auth.client.config.security.AbstractServletSecurityConfig;
import com.elitescloud.boot.auth.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.provider.provider.user.UserDetailManager;
import com.elitescloud.boot.auth.provider.security.generator.ticket.RedisTicketGenerator;
import com.elitescloud.boot.auth.provider.security.generator.ticket.TicketGenerator;
import com.elitescloud.boot.auth.provider.security.generator.token.TokenGenerator;
import com.elitescloud.boot.auth.provider.security.handler.sso.SsoTicketAuthenticationCallable;
import com.elitescloud.boot.auth.provider.sso.SsoLoginSupportController;
import com.elitescloud.boot.auth.provider.sso.SsoLoginSupportProvider;
import com.elitescloud.boot.auth.provider.sso.impl.CloudtSsoLoginSupportProviderImpl;
import com.elitescloud.boot.auth.provider.sso.impl.CloudtSsoProviderImpl;
import com.elitescloud.boot.auth.sso.TicketResolver;
import com.elitescloud.boot.auth.sso.impl.CookieTicketResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(prefix="elitesland.authorization.sdk.sso", name={"enabled"}, havingValue="true")
class SsoConfig
extends AbstractServletSecurityConfig {
    private static final Logger log = LogManager.getLogger(SsoConfig.class);
    private final AuthorizationSdkProperties sdkProperties;

    public SsoConfig(AuthorizationSdkProperties sdkProperties) {
        this.sdkProperties = sdkProperties;
        log.info("\u542f\u7528\u5355\u70b9\u767b\u5f55\u529f\u80fd");
    }

    @Bean
    @ConditionalOnMissingBean
    private CloudtSsoProviderImpl cloudtSsoProvider(TokenGenerator tokenGenerator, AuthenticationCache authenticationCache, UserDetailManager userDetailManager, RedisHelper redisHelper) {
        CloudtSsoProviderImpl provider = new CloudtSsoProviderImpl(tokenGenerator, authenticationCache, userDetailManager, redisHelper);
        provider.setSdkProperties(this.sdkProperties);
        provider.setAuthenticationCallable(DelegateAuthenticationCallable.getInstance());
        return provider;
    }

    @Bean
    public SsoLoginSupportController ssoLoginSupportController(SsoLoginSupportProvider ssoLoginSupportProvider) {
        return new SsoLoginSupportController(ssoLoginSupportProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public SsoLoginSupportProvider ssoLoginSupportProvider(TicketGenerator ticketGenerator, UserDetailManager userDetailManager) {
        return new CloudtSsoLoginSupportProviderImpl(this.sdkProperties, ticketGenerator, userDetailManager);
    }

    @Bean
    public AuthenticationCallable authenticationCallableSsoTicket(TicketGenerator ticketGenerator, TicketResolver ticketResolver) {
        return new SsoTicketAuthenticationCallable(this.sdkProperties, ticketGenerator, ticketResolver);
    }

    @Bean
    @ConditionalOnMissingBean
    public TicketResolver ticketResolverCookie() {
        return new CookieTicketResolver(this.sdkProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={RedisHelper.class})
    public TicketGenerator ticketGenerator(RedisHelper redisHelper) {
        return new RedisTicketGenerator(redisHelper);
    }
}

