/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.properties;

import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.common.SsoTypeEnum;
import com.elitescloud.boot.auth.sso.common.SsoAccountType;
import com.elitescloud.boot.common.ParamIn;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="elitesland.authorization.sso")
public class Sso2Properties {
    public static final String CONFIG_PREFIX = "elitesland.authorization.sso";
    @NestedConfigurationProperty
    private Server server = new Server();
    @NestedConfigurationProperty
    private Client client = new Client();
    @NestedConfigurationProperty
    private UnifyClient unifyClient = new UnifyClient();

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public UnifyClient getUnifyClient() {
        return this.unifyClient;
    }

    public void setUnifyClient(UnifyClient unifyClient) {
        this.unifyClient = unifyClient;
    }

    public static class Server {
        private Boolean enabled = false;
        private Duration ticketTtl = Duration.ofMinutes(30L);
        private Boolean expireTicketOnUsed = true;
        private Boolean validateClient = true;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Duration getTicketTtl() {
            return this.ticketTtl;
        }

        public void setTicketTtl(Duration ticketTtl) {
            this.ticketTtl = ticketTtl;
        }

        public Boolean getExpireTicketOnUsed() {
            return this.expireTicketOnUsed;
        }

        public void setExpireTicketOnUsed(Boolean expireTicketOnUsed) {
            this.expireTicketOnUsed = expireTicketOnUsed;
        }

        public Boolean getValidateClient() {
            return this.validateClient;
        }

        public void setValidateClient(Boolean validateClient) {
            this.validateClient = validateClient;
        }
    }

    public static class Client {
        private Boolean enabled = false;
        private String serverAddr;
        private String clientId;
        private String clientSecret;
        private SsoAccountType accountType = SsoAccountType.USER_NAME;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getServerAddr() {
            return this.serverAddr;
        }

        public void setServerAddr(String serverAddr) {
            this.serverAddr = serverAddr;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public SsoAccountType getAccountType() {
            return this.accountType;
        }

        public void setAccountType(SsoAccountType accountType) {
            this.accountType = accountType;
        }
    }

    public static class UnifyClient {
        private List<UnifyClientProperty> clients = new ArrayList<UnifyClientProperty>();

        public List<UnifyClientProperty> getClients() {
            return this.clients;
        }

        public void setClients(List<UnifyClientProperty> clients) {
            this.clients = clients;
        }
    }

    public static class UnifyClientProperty {
        private boolean enabled = true;
        private String authCode;
        private SsoTypeEnum ssoType;
        private String paramName;
        private ParamIn paramIn = ParamIn.QUERY;
        private InternalAuthenticationGranter.IdType idType = InternalAuthenticationGranter.IdType.USERNAME;
        private String clientId;
        private String clientSecret;
        private Properties properties;

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public ParamIn getParamIn() {
            return this.paramIn;
        }

        public void setParamIn(ParamIn paramIn) {
            this.paramIn = paramIn;
        }

        public InternalAuthenticationGranter.IdType getIdType() {
            return this.idType;
        }

        public void setIdType(InternalAuthenticationGranter.IdType idType) {
            this.idType = idType;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public SsoTypeEnum getSsoType() {
            return this.ssoType;
        }

        public void setSsoType(SsoTypeEnum ssoType) {
            this.ssoType = ssoType;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public String getAuthCode() {
            return this.authCode;
        }

        public void setAuthCode(String authCode) {
            this.authCode = authCode;
        }
    }
}

