/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.servlet.oauth2.configurer;

import com.elitescloud.boot.auth.provider.config.servlet.oauth2.configurer.filter.OAuth2AuthorizationCodeStateAuthenticationFilter;
import com.elitescloud.boot.auth.resolver.UniqueRequestResolver;
import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationEndpointFilter;

public class OAuth2AuthorizationCodeStateFilterSecurityConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<OAuth2AuthorizationCodeStateFilterSecurityConfigurer<H>, H> {
    private final AuthorizationServerSettings authorizationServerSettings;
    private UniqueRequestResolver uniqueRequestResolver;

    public OAuth2AuthorizationCodeStateFilterSecurityConfigurer(AuthorizationServerSettings authorizationServerSettings) {
        this.authorizationServerSettings = authorizationServerSettings;
    }

    public void init(H http) throws Exception {
        super.init(http);
    }

    public void configure(H http) throws Exception {
        OAuth2AuthorizationService authorizationService = (OAuth2AuthorizationService)http.getSharedObject(OAuth2AuthorizationService.class);
        OAuth2AuthorizationCodeStateAuthenticationFilter authenticationFilter = new OAuth2AuthorizationCodeStateAuthenticationFilter(this.authorizationServerSettings.getAuthorizationEndpoint(), authorizationService);
        http.addFilterBefore((Filter)authenticationFilter, OAuth2AuthorizationEndpointFilter.class);
        if (this.uniqueRequestResolver != null) {
            authenticationFilter.setUniqueRequestResolver(this.uniqueRequestResolver);
        }
        super.configure(http);
    }

    public OAuth2AuthorizationCodeStateFilterSecurityConfigurer<H> uniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.uniqueRequestResolver = uniqueRequestResolver;
        return this;
    }
}

