/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.servlet.oauth2.handler;

import com.elitescloud.boot.auth.provider.config.servlet.oauth2.OAuth2AuthorizationCodeRequestCache;
import com.elitescloud.boot.auth.provider.config.servlet.oauth2.handler.AbstractOAuth2ServerHandler;
import com.elitescloud.boot.auth.resolver.UniqueRequestResolver;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.util.StringUtils;

public class OAuth2AuthorizationResponseHandler
extends AbstractOAuth2ServerHandler
implements AuthenticationSuccessHandler {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2AuthorizationResponseHandler.class);
    private final UniqueRequestResolver uniqueRequestResolver;
    private final OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache;

    public OAuth2AuthorizationResponseHandler(UniqueRequestResolver uniqueRequestResolver, OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache) {
        this.uniqueRequestResolver = uniqueRequestResolver;
        this.authorizationCodeRequestCache = authorizationCodeRequestCache;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String reqId;
        OAuth2AuthorizationCodeRequestAuthenticationToken authenticationToken = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication;
        if (authenticationToken.getAuthorizationCode() != null) {
            logger.info("OAuth2 authorize success\uff1a{}", (Object)authenticationToken.getAuthorizationCode().getTokenValue());
        }
        if (StringUtils.hasText((String)(reqId = this.uniqueRequestResolver.analyze(request)))) {
            this.authorizationCodeRequestCache.removeAuthenticationToken(reqId);
        }
        if (this.supportRedirect(request)) {
            this.sendAuthorizationResponse(request, response, (Authentication)authenticationToken);
            return;
        }
        HashMap<String, String> result = new HashMap<String, String>(4);
        result.put("code", authenticationToken.getAuthorizationCode().getTokenValue());
        if (StringUtils.hasText((String)authenticationToken.getState())) {
            result.put("state", authenticationToken.getState());
        }
        this.writeResponse(response, ApiResult.ok(result));
    }
}

