/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.servlet.oauth2.handler;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.CommonAuthenticationToken;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.config.servlet.oauth2.OAuth2AuthorizationCodeRequestCache;
import com.elitescloud.boot.auth.provider.config.servlet.oauth2.handler.AbstractOAuth2ServerHandler;
import com.elitescloud.boot.auth.provider.security.generator.token.TokenGenerator;
import com.elitescloud.boot.auth.resolver.UniqueRequestResolver;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.io.IOException;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2ServerAuthenticationSuccessHandler
extends AbstractOAuth2ServerHandler
implements AuthenticationSuccessHandler {
    private static final Logger log = LogManager.getLogger(OAuth2ServerAuthenticationSuccessHandler.class);
    private RequestCache requestCache = new HttpSessionRequestCache();
    private final String authorizationEndpoint;
    private final AuthorizationProperties authorizationProperties;
    private final OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache;
    private final RegisteredClientRepository clientRepository;
    private final OAuth2AuthorizationService oAuth2AuthorizationService;
    private TokenGenerator tokenGenerator;
    private AuthenticationCallable authenticationCallable;
    private UniqueRequestResolver uniqueRequestResolver;

    public OAuth2ServerAuthenticationSuccessHandler(String authorizationEndpoint, AuthorizationProperties authorizationProperties, OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache, RegisteredClientRepository clientRepository, OAuth2AuthorizationService oAuth2AuthorizationService) {
        this.authorizationEndpoint = authorizationEndpoint;
        this.authorizationProperties = authorizationProperties;
        this.authorizationCodeRequestCache = authorizationCodeRequestCache;
        this.clientRepository = clientRepository;
        this.oAuth2AuthorizationService = oAuth2AuthorizationService;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (authentication instanceof CommonAuthenticationToken) {
            authentication = ((CommonAuthenticationToken)authentication).getOriginal();
        }
        this.beforeReturn(request, response);
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        if (this.attemptToHandleOAuth2Response(request, response, authentication, savedRequest)) {
            this.authenticationCallable.onLogin(request, response, null, authentication);
            return;
        }
        OAuthToken authToken = this.generateToken(authentication);
        ApiResult result = ApiResult.ok((Object)authToken);
        this.writeResponse(response, result);
        request.setAttribute("cloudtLoginResult", (Object)result);
        this.authenticationCallable.onLogin(request, response, authToken == null ? null : authToken.getAccessToken(), authentication);
    }

    private void beforeReturn(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            response.addHeader("X-Auth-SID", session.getId());
        }
    }

    private OAuthToken generateToken(Authentication authentication) {
        if (this.tokenGenerator == null) {
            return null;
        }
        return this.tokenGenerator.generate(authentication);
    }

    private boolean attemptToHandleOAuth2Response(HttpServletRequest request, HttpServletResponse response, Authentication authentication, SavedRequest savedRequest) throws IOException {
        if (savedRequest != null) {
            DefaultSavedRequest defaultSavedRequest = (DefaultSavedRequest)savedRequest;
            if (!CharSequenceUtil.equals((CharSequence)this.obtainServletPath(savedRequest), (CharSequence)this.authorizationEndpoint)) {
                return this.attemptHandleOAuth2Response(request, response, authentication, defaultSavedRequest);
            }
            String[] clientIds = savedRequest.getParameterValues("client_id");
            String clientId = clientIds != null && clientIds.length > 0 ? clientIds[0] : null;
            this.updateOAuth2Authorization(request, clientId, authentication, defaultSavedRequest);
            if (super.supportRedirect(request)) {
                super.sendRedirect(super.getUrlPrefix(defaultSavedRequest, this.authorizationProperties), defaultSavedRequest, request, response);
                return true;
            }
            this.writeOAuth2Response(request, response, defaultSavedRequest);
            return true;
        }
        return this.attemptHandleOAuth2Response(request, response, authentication, null);
    }

    private boolean attemptHandleOAuth2Response(HttpServletRequest request, HttpServletResponse response, Authentication authentication, DefaultSavedRequest savedRequest) throws IOException {
        String reqId = this.uniqueRequestResolver.analyze(request);
        if (StringUtils.hasText((String)reqId)) {
            this.handleOAuth2ResponseByReqId(request, response, authentication, savedRequest, reqId);
            return true;
        }
        String clientId = request.getParameter("client_id");
        if (StringUtils.hasText((String)clientId)) {
            this.handleOAuth2ResponseByClientId(request, response, authentication, clientId);
            return true;
        }
        return false;
    }

    private void handleOAuth2ResponseByClientId(HttpServletRequest request, HttpServletResponse response, Authentication authentication, String clientId) throws IOException {
        log.info("OAuth2 Authorization \uff1a{}, {}", (Object)clientId, (Object)authentication.getName());
        RegisteredClient client = this.clientRepository.findByClientId(clientId);
        if (client == null) {
            log.error("\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728\uff1a{}", (Object)clientId);
            this.writeResponse(response, ApiResult.fail((String)"\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\u914d\u7f6e\u6b63\u5e38"));
            return;
        }
        Set redirectUris = client.getRedirectUris();
        if (CollectionUtils.isEmpty((Collection)redirectUris)) {
            log.error("\u5ba2\u6237\u7aef\u914d\u7f6e\u9519\u8bef\uff0c\u7f3a\u5c11\u914d\u7f6e\u56de\u8c03\u5730\u5740\uff1a{}", (Object)clientId);
            this.writeResponse(response, ApiResult.fail((String)"\u5ba2\u6237\u7aef\u914d\u7f6e\u9519\u8bef\uff0c\u7f3a\u5c11\u914d\u7f6e\u56de\u8c03\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            return;
        }
        String redirectUrl = redirectUris.stream().filter(t -> !t.contains("127.0.0.1")).findFirst().orElse(redirectUris.stream().findFirst().orElse(null));
        String urlPrefix = super.getUrlPrefix(request, this.authorizationProperties);
        String authorizeUrl = UriComponentsBuilder.fromUriString((String)urlPrefix).path(this.authorizationEndpoint).queryParam("client_id", new Object[]{clientId}).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{"openid"}).queryParam("redirect_uri", new Object[]{redirectUrl}).toUriString();
        this.writeResponse(response, ApiResult.ok((Object)authorizeUrl));
    }

    private void handleOAuth2ResponseByReqId(HttpServletRequest request, HttpServletResponse response, Authentication authentication, DefaultSavedRequest savedRequest, String reqId) throws IOException {
        String redirectUri;
        log.info("OAuth2 Authorization \uff1a{}, {}", (Object)reqId, (Object)authentication.getName());
        OAuth2AuthorizationCodeRequestAuthenticationToken codeRequest = this.authorizationCodeRequestCache.getAuthenticationToken(reqId);
        if (codeRequest == null) {
            log.error("\u672a\u627e\u5230\u6388\u6743\u7801\u8ba4\u8bc1\u8bf7\u6c42\u4fe1\u606f\uff1a{}", (Object)reqId);
            this.writeResponse(response, ApiResult.fail((String)"\u8ba4\u8bc1\u4fe1\u606f\u5df2\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5"));
            return;
        }
        RegisteredClient client = this.clientRepository.findByClientId(codeRequest.getClientId());
        if (client == null) {
            this.writeResponse(response, ApiResult.fail((String)"\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528"));
            return;
        }
        OAuth2AuthorizationRequest authorizationRequest = OAuth2AuthorizationRequest.authorizationCode().authorizationUri(codeRequest.getAuthorizationUri()).clientId(codeRequest.getClientId()).redirectUri(codeRequest.getRedirectUri()).scopes(codeRequest.getScopes()).state(codeRequest.getState()).additionalParameters(codeRequest.getAdditionalParameters()).build();
        OAuth2Authorization authorization = OAuth2ServerAuthenticationSuccessHandler.authorizationBuilder(client, authentication, authorizationRequest).attribute("state", (Object)reqId).build();
        this.oAuth2AuthorizationService.save(authorization);
        String string = redirectUri = CollectionUtils.isEmpty((Collection)client.getRedirectUris()) ? null : (String)client.getRedirectUris().stream().filter(CharSequenceUtil::isNotBlank).findFirst().orElse(null);
        if (StringUtils.hasText(redirectUri) && this.supportRedirect(request)) {
            this.sendRedirect(request, response, redirectUri);
            return;
        }
        String urlPrefix = savedRequest == null ? super.getUrlPrefix(request, this.authorizationProperties) : super.getUrlPrefix(savedRequest, this.authorizationProperties);
        String authorizeUrl = this.normalizeUrl(urlPrefix, authorizationRequest.getAuthorizationRequestUri());
        this.writeResponse(response, ApiResult.ok((Object)authorizeUrl));
    }

    private void updateOAuth2Authorization(HttpServletRequest request, String clientId, Authentication authentication, DefaultSavedRequest savedRequest) {
        String reqId = this.uniqueRequestResolver.analyze(request);
        if (!StringUtils.hasText((String)reqId)) {
            log.debug("\u7f3a\u5c11state\u53c2\u6570\uff0c\u65e0\u6cd5\u786e\u5b9a\u4e3aOAuth2\u8bf7\u6c42");
            return;
        }
        log.info("OAuth2\u8ba4\u8bc1\u8bf7\u6c42\uff1a{}\uff0c{}", (Object)savedRequest.getRequestURL(), (Object)savedRequest.getQueryString());
        RegisteredClient client = this.clientRepository.findByClientId(clientId);
        if (client == null) {
            log.error("\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\uff1a{}", (Object)clientId);
            return;
        }
        HashSet<String> scopes = null;
        String scope = super.getParameter(savedRequest, "scope");
        if (StringUtils.hasText((String)scope)) {
            scopes = new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
        }
        HashMap additionalParameters = new HashMap();
        savedRequest.getParameterMap().forEach((key, value) -> {
            if (!(key.equals("response_type") || key.equals("client_id") || key.equals("redirect_uri") || key.equals("scope") || key.equals("state"))) {
                additionalParameters.put(key, value[0]);
            }
        });
        OAuth2AuthorizationRequest authorizationRequest = OAuth2AuthorizationRequest.authorizationCode().authorizationUri(savedRequest.getRequestURL()).clientId(clientId).redirectUri(super.getParameter(savedRequest, "redirect_uri")).scopes(scopes).state(super.getParameter(savedRequest, "state")).additionalParameters(additionalParameters).build();
        OAuth2Authorization authorization = OAuth2ServerAuthenticationSuccessHandler.authorizationBuilder(client, authentication, authorizationRequest).attribute("state", (Object)reqId).build();
        this.oAuth2AuthorizationService.save(authorization);
    }

    private String normalizeUrl(String uriPrefix, String url) {
        if (!StringUtils.hasText((String)uriPrefix)) {
            return url;
        }
        UriComponents uri = UriComponentsBuilder.fromUriString((String)url).build();
        return UriComponentsBuilder.fromUriString((String)uriPrefix).path(uri.getPath()).query(uri.getQuery()).build().toString();
    }

    private void writeOAuth2Response(HttpServletRequest request, HttpServletResponse response, DefaultSavedRequest savedRequest) throws IOException {
        String urlPrefix = savedRequest == null ? super.getUrlPrefix(request, this.authorizationProperties) : super.getUrlPrefix(savedRequest, this.authorizationProperties);
        String redirectUrl = super.obtainRedirectUrl(urlPrefix, savedRequest);
        super.writeResponse(response, (Object)ApiResult.ok((Object)redirectUrl));
    }

    private String obtainServletPath(SavedRequest savedRequest) {
        if (savedRequest instanceof DefaultSavedRequest) {
            DefaultSavedRequest request = (DefaultSavedRequest)savedRequest;
            return CharSequenceUtil.blankToDefault((CharSequence)request.getServletPath(), (String)request.getRequestURI());
        }
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684SavedRequest\u7c7b\u578b");
    }

    private static OAuth2Authorization.Builder authorizationBuilder(RegisteredClient registeredClient, Authentication principal, OAuth2AuthorizationRequest authorizationRequest) {
        return OAuth2Authorization.withRegisteredClient((RegisteredClient)registeredClient).principalName(principal.getName()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).attribute(Principal.class.getName(), (Object)principal).attribute(OAuth2AuthorizationRequest.class.getName(), (Object)authorizationRequest).attribute("client_id", (Object)registeredClient.getClientId()).attribute("expires_in", (Object)Instant.now().plus(Duration.ofMinutes(5L)).getEpochSecond());
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public void setAuthenticationCallable(AuthenticationCallable authenticationCallable) {
        this.authenticationCallable = authenticationCallable;
    }

    public void setUniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.uniqueRequestResolver = uniqueRequestResolver;
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }
}

