/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.servlet.oauth2.handler;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.provider.config.servlet.oauth2.OAuth2AuthorizationCodeRequestCache;
import com.elitescloud.boot.auth.resolver.UniqueRequestResolver;
import com.elitescloud.boot.util.ObjUtil;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2AuthorizationCodeRequestAuthenticationConverter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.util.StringUtils;

public class OAuth2ServerLoginUrlAuthenticationEntryPointHandler
extends LoginUrlAuthenticationEntryPoint {
    private static final Logger log = LogManager.getLogger(OAuth2ServerLoginUrlAuthenticationEntryPointHandler.class);
    private final AuthorizationProperties properties;
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache;
    private UniqueRequestResolver uniqueRequestResolver = null;
    private RequestCache requestCache;
    private final ThreadLocal<String> seqLocal = new ThreadLocal();

    public OAuth2ServerLoginUrlAuthenticationEntryPointHandler(AuthorizationProperties properties, RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache) {
        super(properties.getLoginPage());
        this.properties = properties;
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationCodeRequestCache = authorizationCodeRequestCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        log.info("{}\u672a\u8ba4\u8bc1\uff0c\u5c06\u8f6c\u5411\u767b\u5f55\u9875", (Object)request.getRequestURI());
        if (this.uniqueRequestResolver != null) {
            OAuth2AuthorizationCodeRequestAuthenticationToken codeRequest = (OAuth2AuthorizationCodeRequestAuthenticationToken)new OAuth2AuthorizationCodeRequestAuthenticationConverter().convert(request);
            String seqId = this.uniqueRequestResolver.signRequest(response);
            this.seqLocal.set(seqId);
            this.authorizationCodeRequestCache.setAuthenticationToken(seqId, codeRequest, Duration.ofDays(7L));
        }
        if (this.requestCache != null) {
            this.requestCache.saveRequest(request, response);
        }
        try {
            super.commence(request, response, authException);
        }
        finally {
            this.seqLocal.remove();
        }
    }

    protected String determineUrlToUseForThisRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        Object clientLoginPage;
        String clientId = this.obtainClientId(request);
        log.info("authorize client: {}", (Object)clientId);
        if (StringUtils.hasText((String)clientId) && StringUtils.hasText((String)(clientLoginPage = this.obtainClientLoginPage(clientId)))) {
            String seqId = this.seqLocal.get();
            if (StringUtils.hasText((String)seqId)) {
                clientLoginPage = (((String)clientLoginPage).contains("?") ? (String)clientLoginPage + "&" : (String)clientLoginPage + "?") + "ClientId=" + clientId + "&Urq=" + seqId;
            }
            String loginUrl = this.normalizeRedirectUrl((String)clientLoginPage, request.getHeader("Referer"));
            log.info("client customize loginUrl\uff1a{}", (Object)loginUrl);
            return loginUrl;
        }
        Object loginPage = this.properties.getLoginPage();
        if (!StringUtils.hasText((String)loginPage)) {
            log.warn("\u672a\u914d\u7f6e\u767b\u5f55\u9875\u5730\u5740");
            return loginPage;
        }
        loginPage = (((String)loginPage).contains("?") ? (String)loginPage + "&" : (String)loginPage + "?") + "ClientId=" + (String)ObjUtil.defaultIfNull((Object)clientId, (Object)"");
        String resultPage = this.normalizeRedirectUrl((String)loginPage, request.getParameter("authSvr"));
        log.info("loginUrl:{} -> {}", loginPage, (Object)resultPage);
        return resultPage;
    }

    public void setUniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.uniqueRequestResolver = uniqueRequestResolver;
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }

    private String normalizeRedirectUrl(@NotBlank String url, String referUrl) {
        String tempUrl = url.toLowerCase();
        if (tempUrl.startsWith("http://") || tempUrl.startsWith("https://")) {
            return url;
        }
        String urlPrefix = null;
        if (StringUtils.hasText((String)referUrl)) {
            String referPath = URI.create(referUrl).getPath();
            String string = urlPrefix = StringUtils.hasText((String)referPath) ? referUrl.substring(0, referUrl.indexOf(referPath)) : referUrl;
        }
        if (!StringUtils.hasText(urlPrefix)) {
            urlPrefix = this.properties.getRedirectUriPrefix();
        }
        if (urlPrefix == null) {
            urlPrefix = "/";
        }
        return url.startsWith("/") ? urlPrefix + url : urlPrefix + "/" + url;
    }

    private String convertUrlForRefer(String url, String referer) {
        URI uri = URI.create(url);
        String path = CharSequenceUtil.blankToDefault((CharSequence)uri.getPath(), (String)"");
        URI refererUri = URI.create(referer);
        String pathReferPath = refererUri.getPath();
        if (!StringUtils.hasText((String)pathReferPath)) {
            return referer + path;
        }
        return referer.substring(0, referer.indexOf(pathReferPath)) + path;
    }

    private String obtainClientLoginPage(String clientId) {
        RegisteredClient client = this.registeredClientRepository.findByClientId(clientId);
        if (client == null) {
            return null;
        }
        return (String)client.getClientSettings().getSetting("loginUrl");
    }

    private String obtainClientId(HttpServletRequest request) {
        return request.getParameter("client_id");
    }
}

