/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.system;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.captcha.generator.RandomGenerator;
import cn.hutool.core.util.RandomUtil;
import com.elitescloud.boot.auth.provider.common.LoginAccountType;
import com.elitescloud.boot.auth.provider.common.LoginDeviceLimitStrategy;
import com.elitescloud.boot.auth.provider.config.system.CaptchaInfo;
import com.elitescloud.boot.auth.provider.config.system.captcha.CaptchaCharEnum;
import com.elitescloud.boot.auth.provider.config.system.captcha.CaptchaCodeEnum;
import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.ChineseCaptcha;
import com.wf.captcha.ChineseGifCaptcha;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class LoginProperties
implements Serializable {
    private static final long serialVersionUID = 3572914221247822407L;
    @NestedConfigurationProperty
    private CaptchaInfo captchaInfo = new CaptchaInfo();
    private List<String> tokenPayloads = new ArrayList<String>(8);
    private Boolean terminalLimit = false;
    private Boolean autoRegister = false;
    private Set<LoginAccountType> loginAccountTypes = Set.of(LoginAccountType.USERNAME, LoginAccountType.MOBILE);
    private List<LoginDeviceLimiter> loginDeviceLimiters = new ArrayList<LoginDeviceLimiter>(0);

    public AbstractCaptcha getCaptchaHu() {
        if (Objects.isNull(this.captchaInfo)) {
            return null;
        }
        if (this.captchaInfo.getCodeType() == CaptchaCodeEnum.line || this.captchaInfo.getCodeType() == CaptchaCodeEnum.circle || this.captchaInfo.getCodeType() == CaptchaCodeEnum.shear) {
            LineCaptcha captcha = null;
            switch (this.captchaInfo.getCodeType()) {
                case line: {
                    captcha = CaptchaUtil.createLineCaptcha((int)this.captchaInfo.getWidth(), (int)this.captchaInfo.getHeight());
                    break;
                }
                case circle: {
                    captcha = CaptchaUtil.createCircleCaptcha((int)this.captchaInfo.getWidth(), (int)this.captchaInfo.getHeight());
                    break;
                }
                default: {
                    captcha = CaptchaUtil.createShearCaptcha((int)this.captchaInfo.getWidth(), (int)this.captchaInfo.getHeight());
                }
            }
            Object baseStr = null;
            switch (this.captchaInfo.getCharType()) {
                case NUMBER: {
                    baseStr = "0123456789";
                    break;
                }
                case CHAR: {
                    baseStr = "abcdefghijklmnopqrstuvwxyz" + "abcdefghijklmnopqrstuvwxyz".toUpperCase();
                    break;
                }
                case CHAR_UPPER: {
                    baseStr = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
                    break;
                }
                case CHAR_LOWER: {
                    baseStr = "abcdefghijklmnopqrstuvwxyz";
                    break;
                }
                case NUMBER_CHAR_UPPER: {
                    baseStr = "abcdefghijklmnopqrstuvwxyz0123456789".toUpperCase();
                    break;
                }
                default: {
                    baseStr = RandomUtil.BASE_CHAR_NUMBER;
                }
            }
            captcha.setGenerator((CodeGenerator)new RandomGenerator((String)baseStr, this.captchaInfo.getLength()));
            return captcha;
        }
        return null;
    }

    public Captcha getCaptcha() {
        if (Objects.isNull(this.captchaInfo)) {
            this.captchaInfo = new CaptchaInfo();
            if (Objects.isNull((Object)this.captchaInfo.getCodeType())) {
                this.captchaInfo.setCodeType(CaptchaCodeEnum.arithmetic);
            }
            if (Objects.isNull((Object)this.captchaInfo.getCharType())) {
                this.captchaInfo.setCharType(CaptchaCharEnum.DEFAULT);
            }
        }
        return this.switchCaptcha(this.captchaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Captcha switchCaptcha(CaptchaInfo captchaInfo) {
        ArithmeticCaptcha captcha;
        LoginProperties loginProperties = this;
        synchronized (loginProperties) {
            switch (captchaInfo.getCodeType()) {
                case arithmetic: {
                    captcha = new ArithmeticCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    break;
                }
                case chinese: {
                    captcha = new ChineseCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    break;
                }
                case chinese_gif: {
                    captcha = new ChineseGifCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    break;
                }
                case gif: {
                    captcha = new GifCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    break;
                }
                case spec: {
                    captcha = new SpecCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    break;
                }
                default: {
                    throw new RuntimeException("\u9a8c\u8bc1\u7801\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff01\uff01\uff01\u6b63\u786e\u914d\u7f6e\u67e5\u770b " + CaptchaCodeEnum.class.getName());
                }
            }
        }
        captcha.setLen(captchaInfo.getLength());
        switch (captchaInfo.getCharType()) {
            case NUMBER: {
                captcha.setCharType(2);
                break;
            }
            case CHAR: {
                captcha.setCharType(3);
                break;
            }
            case CHAR_UPPER: {
                captcha.setCharType(4);
                break;
            }
            case CHAR_LOWER: {
                captcha.setCharType(5);
                break;
            }
            case NUMBER_CHAR_UPPER: {
                captcha.setCharType(6);
                break;
            }
            default: {
                captcha.setCharType(1);
            }
        }
        return captcha;
    }

    public List<String> getTokenPayloads() {
        return this.tokenPayloads;
    }

    public void setTokenPayloads(List<String> tokenPayloads) {
        this.tokenPayloads = tokenPayloads;
    }

    public CaptchaInfo getCaptchaInfo() {
        return this.captchaInfo;
    }

    public void setCaptchaInfo(CaptchaInfo captchaInfo) {
        this.captchaInfo = captchaInfo;
    }

    public Boolean getTerminalLimit() {
        return this.terminalLimit;
    }

    public void setTerminalLimit(Boolean terminalLimit) {
        this.terminalLimit = terminalLimit;
    }

    public Boolean getAutoRegister() {
        return this.autoRegister;
    }

    public void setAutoRegister(Boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public Set<LoginAccountType> getLoginAccountTypes() {
        return this.loginAccountTypes;
    }

    public void setLoginAccountTypes(Set<LoginAccountType> loginAccountTypes) {
        this.loginAccountTypes = loginAccountTypes;
    }

    public List<LoginDeviceLimiter> getLoginDeviceLimiters() {
        return this.loginDeviceLimiters;
    }

    public void setLoginDeviceLimiters(List<LoginDeviceLimiter> loginDeviceLimiters) {
        this.loginDeviceLimiters = loginDeviceLimiters;
    }

    public static class LoginDeviceLimiter {
        private String clientId;
        private LoginDeviceLimitStrategy strategy = LoginDeviceLimitStrategy.NO_LIMIT;
        private String oneLimitTip = "\u60a8\u5df2\u5728\u5176\u5b83\u8bbe\u5907\u767b\u5f55";

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public LoginDeviceLimitStrategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(LoginDeviceLimitStrategy strategy) {
            this.strategy = strategy;
        }

        public String getOneLimitTip() {
            return this.oneLimitTip;
        }

        public void setOneLimitTip(String oneLimitTip) {
            this.oneLimitTip = oneLimitTip;
        }
    }
}

