/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.provider.alipay;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.auth.provider.common.AlipayAppProvider;
import com.elitescloud.boot.auth.provider.common.param.AlipayApp;
import com.elitescloud.boot.auth.provider.provider.alipay.AlipayTool;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.JSONUtil;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlipayTemplate {
    private static final Logger logger = LoggerFactory.getLogger(AlipayTemplate.class);
    private final AlipayAppProvider appProvider;
    private final RedisHelper redisHelper;

    public AlipayTemplate(AlipayAppProvider appProvider, RedisHelper redisHelper) {
        this.appProvider = appProvider;
        this.redisHelper = redisHelper;
    }

    public AlipaySystemOauthTokenResponse oauthToken(@NotBlank String appId, @NotBlank String code) {
        Assert.notBlank((CharSequence)appId, (String)"\u5e94\u7528ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)code, (String)"\u652f\u4ed8\u5b9d\u6388\u6743\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        logger.info("\u83b7\u53d6\u6388\u6743\u4ee4\u724c\uff1a{}\uff0c{}", (Object)appId, (Object)code);
        AlipayApp app = this.appProvider.getApp(appId);
        if (app == null) {
            throw new BusinessException("\u652f\u4ed8\u5b9d\u5e94\u7528\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e");
        }
        try {
            return AlipayTool.systemOAuthToken(app, code);
        }
        catch (Exception e) {
            throw new BusinessException("\u652f\u4ed8\u5b9d\u6388\u6743\u5931\u8d25", (Throwable)e);
        }
    }

    public String getPhoneNumber(@NotBlank String appId, @NotBlank String encryptedResp) throws Exception {
        Assert.notBlank((CharSequence)appId, (String)"\u5e94\u7528ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)encryptedResp, (String)"\u652f\u4ed8\u5b9d\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a", (Object[])new Object[0]);
        logger.info("\u83b7\u53d6\u624b\u673a\u53f7\uff1a{}\uff0c{}", (Object)appId, (Object)encryptedResp);
        AlipayApp app = this.appProvider.getApp(appId);
        if (app == null) {
            throw new BusinessException("\u652f\u4ed8\u5b9d\u5e94\u7528\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e");
        }
        Map resp = (Map)JSONUtil.json2Obj((String)encryptedResp, (boolean)true, () -> "\u89e3\u6790\u652f\u4ed8\u5b9d\u54cd\u5e94\u5185\u5bb9\u5f02\u5e38");
        Object response = resp.get("response");
        if (!(response instanceof String)) {
            Map responseMap = (Map)response;
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u652f\u4ed8\u5b9d\u54cd\u5e94\uff1a" + String.valueOf(responseMap.get("code")) + ", " + String.valueOf(responseMap.get("subCode")) + ", " + String.valueOf(responseMap.get("subMsg")));
        }
        String sign = (String)resp.get("sign");
        logger.info("\u9a8c\u7b7e\uff1a {}, {}, {}", new Object[]{response, sign, app.getPublicKeyAlipay()});
        if (CharSequenceUtil.isNotBlank((CharSequence)sign)) {
            Object signContent;
            String content = (String)response;
            Object object = signContent = content.startsWith("{") ? content : "\"" + content + "\"";
            if (!AlipayTool.RSA2.verifySign((String)signContent, sign, app.getPublicKeyAlipay())) {
                throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u9a8c\u8bc1\u54cd\u5e94\u5185\u5bb9\u5931\u8d25");
            }
        }
        String decryptedResp = AlipayTool.AES.decrypt(app.getAesKey(), (String)response);
        logger.info("\u89e3\u5bc6\u54cd\u5e94\u4fe1\u606f\uff1a{}", (Object)decryptedResp);
        Map data = (Map)JSONUtil.json2Obj((String)decryptedResp, (boolean)true, () -> "\u89e3\u6790\u652f\u4ed8\u5b9d\u54cd\u5e94\u5185\u5bb9\u5f02\u5e38");
        if (data.containsKey("subMsg") && !data.containsKey("mobile")) {
            throw new BusinessException("\u83b7\u53d6\u7528\u6237\u624b\u673a\u53f7\u5931\u8d25\uff0c" + data.containsKey("subMsg"));
        }
        return (String)data.get("mobile");
    }
}

