/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.provider.alipay;

import com.alipay.api.AlipayConfig;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.internal.util.AlipayEncrypt;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.elitescloud.boot.auth.provider.common.param.AlipayApp;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

public class AlipayTool {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String SERVER_URL = "https://openapi.alipay.com/gateway.do";

    public static AlipaySystemOauthTokenResponse systemOAuthToken(@NotNull AlipayApp app, @NotBlank String code) throws Exception {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(AlipayTool.convertConfig(app));
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setCode(code);
        request.setGrantType("authorization_code");
        return (AlipaySystemOauthTokenResponse)alipayClient.execute((AlipayRequest)request);
    }

    private static AlipayConfig convertConfig(AlipayApp app) {
        AlipayConfig config = new AlipayConfig();
        config.setServerUrl(SERVER_URL);
        config.setAppId(app.getAppId());
        config.setFormat("json");
        config.setCharset(CHARSET.name());
        config.setSignType("RSA2");
        config.setPrivateKey(app.getPrivateKey());
        config.setAlipayPublicKey(app.getPublicKeyAlipay());
        return config;
    }

    public static class AES {
        private static final String PADDING_ALGORITHM = "AES/CBC/PKCS5Padding";
        private static final String ALGORITHM = "AES";

        public static String encrypt(@NotBlank String encryptKey, @NotBlank String content) throws Exception {
            return AlipayEncrypt.encryptContent((String)content, (String)ALGORITHM, (String)encryptKey, (String)CHARSET.name());
        }

        public static String decrypt(@NotBlank String encryptKey, String content) throws Exception {
            return AlipayEncrypt.decryptContent((String)content, (String)ALGORITHM, (String)encryptKey, (String)CHARSET.name());
        }
    }

    public static class RSA {
        private static final String ASYMMETRIC_TYPE = "RSA";
        private static final String SIGNATURE_ALGORITHM = "SHA1WithRSA";
        private static final int MAX_ENCRYPT_BLOCK_SIZE = 117;
        private static final int MAX_DECRYPT_BLOCK_SIZE = 128;

        public static String sign(@NotBlank String content, @NotBlank String privateKeyStr) throws Exception {
            return AlipaySignature.rsaSign((String)content, (String)privateKeyStr, (String)CHARSET.name());
        }

        public static boolean verifySign(@NotBlank String content, @NotBlank String sign, @NotBlank String publicKeyStr) throws Exception {
            return AlipaySignature.rsaCheckContent((String)content, (String)sign, (String)publicKeyStr, (String)CHARSET.name());
        }

        public static String encrypt(@NotBlank String content, @NotBlank String publicKeyStr) throws Exception {
            return AlipaySignature.encrypt((String)content, (String)publicKeyStr, (String)CHARSET.name(), (String)ASYMMETRIC_TYPE);
        }

        public static String decrypt(@NotBlank String cipherText, @NotBlank String privateKeyStr) throws Exception {
            return AlipaySignature.decrypt((String)cipherText, (String)privateKeyStr, (String)CHARSET.name(), (String)ASYMMETRIC_TYPE);
        }
    }

    public static class RSA2 {
        private static final String ASYMMETRIC_TYPE = "RSA";
        private static final String SIGNATURE_ALGORITHM = "SHA256WithRSA";
        private static final int MAX_ENCRYPT_BLOCK_SIZE = 244;
        private static final int MAX_DECRYPT_BLOCK_SIZE = 256;

        public static String sign(@NotBlank String content, @NotBlank String privateKeyStr) throws Exception {
            return AlipaySignature.rsa256Sign((String)content, (String)privateKeyStr, (String)CHARSET.name());
        }

        public static boolean verifySign(@NotBlank String content, @NotBlank String sign, @NotBlank String publicKeyStr) throws Exception {
            return AlipaySignature.rsa256CheckContent((String)content, (String)sign, (String)publicKeyStr, (String)CHARSET.name());
        }

        public static String encrypt(@NotBlank String content, @NotBlank String publicKeyStr) throws Exception {
            return AlipaySignature.encrypt((String)content, (String)publicKeyStr, (String)CHARSET.name(), (String)"RSA2");
        }

        public static String decrypt(@NotBlank String cipherText, @NotBlank String privateKeyStr) throws Exception {
            return AlipaySignature.decrypt((String)cipherText, (String)privateKeyStr, (String)CHARSET.name(), (String)"RSA2");
        }
    }
}

