/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.provider.wechat;

import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatAccessToken;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatCode2Session;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatPhoneInfo;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatToken;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatUserInfo;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.boot.util.RestTemplateHelper;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.web.client.RestTemplate;

public class WechatTool {
    private static final Logger logger = LoggerFactory.getLogger(WechatTool.class);
    private final RestTemplateHelper restTemplateHelper = RestTemplateHelper.instance((RestTemplate)RestTemplateFactory.instance());

    private WechatTool() {
    }

    public static WechatTool getInstance() {
        return new WechatTool();
    }

    public WechatToken getAccessToken(@NotBlank String appId, @NotBlank String appSecret) {
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";
        WechatToken wechatToken = (WechatToken)this.restTemplateHelper.exchangeSafely(url = url.replace("APPID", appId).replace("APPSECRET", appSecret), HttpMethod.GET, null, (TypeReference)new TypeReference<WechatToken>(){}, new Object[0]);
        if (wechatToken.isSuccess()) {
            return wechatToken;
        }
        logger.error("\u83b7\u53d6\u5fae\u4fe1accessToken\u5931\u8d25, {}, {}", (Object)wechatToken.getErrCode(), (Object)wechatToken.getErrMsg());
        return null;
    }

    public WechatPhoneInfo getPhoneNumber(@NotBlank String accessToken, @NotBlank String code) {
        String url = "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=ACCESS_TOKEN";
        WechatPhoneInfo phoneInfo = (WechatPhoneInfo)this.restTemplateHelper.exchangeSafely(url = url.replace("ACCESS_TOKEN", accessToken), HttpMethod.POST, new HttpEntity(Map.of("code", code)), (TypeReference)new TypeReference<WechatPhoneInfo>(){}, new Object[0]);
        if (phoneInfo.isSuccess()) {
            return phoneInfo;
        }
        logger.error("\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u624b\u673a\u53f7\u5931\u8d25, {}, {}", (Object)phoneInfo.getErrCode(), (Object)phoneInfo.getErrMsg());
        return null;
    }

    public WechatCode2Session jscode2Session(@NonNull String appId, @NonNull String secret, @NonNull String jsCode) {
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid=APPID&secret=SECRET&js_code=JSCODE&grant_type=authorization_code";
        WechatCode2Session sessionInfo = (WechatCode2Session)this.restTemplateHelper.exchangeSafely(url = url.replace("APPID", appId).replace("SECRET", secret).replace("JSCODE", jsCode), HttpMethod.GET, null, (TypeReference)new TypeReference<WechatCode2Session>(){}, new Object[0]);
        if (sessionInfo.isSuccess()) {
            return sessionInfo;
        }
        logger.error("\u83b7\u53d6\u5c0f\u7a0b\u5e8fOpenId\u5931\u8d25, {}, {}", (Object)sessionInfo.getErrCode(), (Object)sessionInfo.getErrMsg());
        return null;
    }

    public WechatAccessToken oauth2AccessToken(@NonNull String appId, @NonNull String secret, @NonNull String code) {
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=SECRET&code=CODE&grant_type=authorization_code";
        WechatAccessToken accessToken = (WechatAccessToken)this.restTemplateHelper.exchangeSafely(url = url.replace("APPID", appId).replace("SECRET", secret).replace("CODE", code), HttpMethod.GET, null, (TypeReference)new TypeReference<WechatAccessToken>(){}, new Object[0]);
        if (accessToken.isSuccess()) {
            return accessToken;
        }
        logger.error("\u83b7\u53d6\u5fae\u4fe1AccessToken\u5931\u8d25, {}, {}", (Object)accessToken.getErrCode(), (Object)accessToken.getErrMsg());
        return null;
    }

    public WechatUserInfo snsUserInfo(String accessToken, String openId) {
        String url = "https://api.weixin.qq.com/sns/userinfo?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";
        WechatUserInfo userInfo = (WechatUserInfo)this.restTemplateHelper.exchangeSafely(url = url.replace("ACCESS_TOKEN", accessToken).replace("OPENID", openId), HttpMethod.GET, null, (TypeReference)new TypeReference<WechatUserInfo>(){}, new Object[0]);
        if (userInfo.isSuccess()) {
            return userInfo;
        }
        logger.error("\u83b7\u53d6\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u5931\u8d25, {}, {}", (Object)userInfo.getErrCode(), (Object)userInfo.getErrMsg());
        return null;
    }
}

