/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.client.common.AuthenticateBeforeHandler;
import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CustomGrantAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    public static final String DEFAULT_FILTER_PROCESS_URI = "/oauth/login";
    private final Map<String, AbstractCustomAuthenticationToken<?>> authenticationTokenMap = new HashMap();
    private List<AuthenticateBeforeHandler> authenticateBeforeHandlers;

    public CustomGrantAuthenticationFilter() {
        this(DEFAULT_FILTER_PROCESS_URI);
    }

    public CustomGrantAuthenticationFilter(String defaultFilterProcessesUrl) {
        super((RequestMatcher)new AntPathRequestMatcher(defaultFilterProcessesUrl, HttpMethod.POST.name()));
    }

    public <T extends AbstractCustomAuthenticationToken> void addAuthenticationTokenConvert(T authenticationToken) {
        LoginType loginType = authenticationToken.loginType();
        Assert.notNull((Object)loginType, (String)(authenticationToken.getClass().getName() + "\u7684loginType\u4e3a\u7a7a"));
        this.authenticationTokenMap.put(loginType.getType(), authenticationToken);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        request.setAttribute("cloudtLoginStartTime", (Object)LocalDateTime.now());
        String loginType = request.getParameter("login_type");
        if (!StringUtils.hasText((String)loginType)) {
            throw new AuthenticationServiceException("\u672a\u77e5\u767b\u5f55\u7c7b\u578b");
        }
        AbstractCustomAuthenticationToken<?> authenticationToken = this.authenticationTokenMap.get(loginType);
        if (authenticationToken == null) {
            throw new AuthenticationServiceException("\u4e0d\u652f\u6301\u7684\u767b\u5f55\u7c7b\u578b");
        }
        AbstractCustomAuthenticationToken authentication = authenticationToken.convert(request);
        this.setDetails(request, (AbstractAuthenticationToken)authentication);
        request.setAttribute("cloudtAuthenticationOriginal", (Object)authentication);
        this.beforeAuthenticate(request, response);
        return this.getAuthenticationManager().authenticate((Authentication)authentication);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        this.logger.trace((Object)"Failed to process authentication request", (Throwable)failed);
        this.logger.trace((Object)"Cleared SecurityContextHolder");
        this.logger.trace((Object)"Handling authentication failure");
        this.logger.info((Object)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7");
        this.getRememberMeServices().loginFail(request, response);
        this.getFailureHandler().onAuthenticationFailure(request, response, failed);
    }

    private void setDetails(HttpServletRequest request, AbstractAuthenticationToken authentication) {
        authentication.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    private List<AuthenticateBeforeHandler> getAuthenticateBeforeHandlers() {
        if (this.authenticateBeforeHandlers == null) {
            this.authenticateBeforeHandlers = SpringContextHolder.getObjectProvider(AuthenticateBeforeHandler.class).stream().collect(Collectors.toList());
        }
        return this.authenticateBeforeHandlers;
    }

    private void beforeAuthenticate(HttpServletRequest request, HttpServletResponse response) {
        String clientId = request.getParameter("client_id");
        if (CharSequenceUtil.isNotBlank((CharSequence)clientId)) {
            request.setAttribute("cloudtClientId", (Object)clientId);
        }
        if (CollUtil.isNotEmpty(this.getAuthenticateBeforeHandlers())) {
            for (AuthenticateBeforeHandler authenticateBeforeHandler : this.getAuthenticateBeforeHandlers()) {
                authenticateBeforeHandler.handle(request, response);
            }
        }
        SecurityContextHolder.clearContext();
    }
}

