/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.alipay_minapp;

import cn.hutool.core.text.CharSequenceUtil;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.provider.alipay.AlipayTemplate;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.security.grant.alipay_minapp.AlipayMinappAuthenticationToken;
import com.elitescloud.boot.auth.provider.security.jackson.mixin.grant.MixinAlipayMinappAuthenticationToken;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

public class AlipayMinappAuthenticationProvider
extends AbstractCustomAuthenticationProvider<AlipayMinappAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(AlipayMinappAuthenticationProvider.class);
    @Autowired
    private AlipayTemplate alipayTemplate;

    @Override
    protected GeneralUserDetails retrieveUser(AlipayMinappAuthenticationToken authentication) throws AuthenticationException {
        String openId;
        String appId = (String)authentication.getPrincipal();
        if (!StringUtils.hasText((String)appId)) {
            throw new AuthorizationException("\u5e94\u7528ID\u4e3a\u7a7a");
        }
        if (StringUtils.hasText((String)authentication.getOpenId())) {
            GeneralUserDetails user = this.userDetailManager.loadUserByOpenId(appId, authentication.getOpenId());
            if (user == null) {
                throw new UsernameNotFoundException("\u6682\u672a\u7ed1\u5b9a\u8be5\u652f\u4ed8\u5b9d\u8d26\u53f7");
            }
            return user;
        }
        String resp = (String)authentication.getCredentials();
        if (!StringUtils.hasText((String)resp)) {
            throw new AuthorizationException("\u652f\u4ed8\u5b9d\u6388\u6743\u5185\u5bb9\u4e3a\u7a7a");
        }
        AlipaySystemOauthTokenResponse tokenResponse = this.alipayTemplate.oauthToken(appId, resp);
        if (tokenResponse == null) {
            throw new AuthorizationException("\u652f\u4ed8\u5b9d\u6388\u6743\u5f02\u5e38");
        }
        String string = openId = authentication.isPreferUserId() ? tokenResponse.getUserId() : tokenResponse.getOpenId();
        if (CharSequenceUtil.isBlank((CharSequence)openId)) {
            throw new AuthorizationException("\u652f\u4ed8\u5b9d\u6388\u6743\u5931\u8d25");
        }
        GeneralUserDetails user = this.userDetailManager.loadUserByOpenId(appId, openId);
        if (user == null) {
            throw new UsernameNotFoundException("\u6682\u672a\u7ed1\u5b9a\u8be5\u652f\u4ed8\u5b9d\u8d26\u53f7");
        }
        return user;
    }

    @Override
    public Class<AlipayMinappAuthenticationToken> getAuthenticationTokenType() {
        return AlipayMinappAuthenticationToken.class;
    }

    @Override
    public Class<?> getMixinAuthenticationTokenType() {
        return MixinAlipayMinappAuthenticationToken.class;
    }
}

