/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.alipay_phone;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.provider.alipay.AlipayTemplate;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.security.grant.alipay_phone.AlipayPhoneAuthenticationToken;
import com.elitescloud.boot.auth.provider.security.jackson.mixin.grant.MixinAlipayPhoneAuthenticationToken;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class AlipayPhoneAuthenticationProvider
extends AbstractCustomAuthenticationProvider<AlipayPhoneAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(AlipayPhoneAuthenticationProvider.class);
    @Autowired
    private AlipayTemplate alipayTemplate;

    @Override
    protected GeneralUserDetails retrieveUser(AlipayPhoneAuthenticationToken authentication) throws AuthenticationException {
        GeneralUserDetails user;
        String appId = (String)authentication.getPrincipal();
        if (!StringUtils.hasText((String)appId)) {
            throw new AuthorizationException("\u5e94\u7528ID\u4e3a\u7a7a");
        }
        String resp = (String)authentication.getCredentials();
        if (!StringUtils.hasText((String)resp)) {
            throw new AuthorizationException("\u652f\u4ed8\u5b9d\u6388\u6743\u5185\u5bb9\u4e3a\u7a7a");
        }
        if (authentication.isAutoRegister() && Boolean.FALSE.equals(this.configProperties.getLogin().getAutoRegister())) {
            throw new AuthorizationException("\u4e0d\u652f\u6301\u81ea\u52a8\u6ce8\u518c\u8d26\u53f7");
        }
        String phone = null;
        try {
            phone = this.alipayTemplate.getPhoneNumber(appId, resp);
        }
        catch (Exception e) {
            Object msg = e instanceof IllegalArgumentException || e instanceof BusinessException ? ", " + e.getMessage() : "";
            throw new AuthorizationException("\u652f\u4ed8\u5b9d\u6388\u6743\u83b7\u53d6\u624b\u673a\u53f7\u5f02\u5e38" + (String)msg, (Throwable)e);
        }
        if (CharSequenceUtil.isBlank((CharSequence)phone)) {
            throw new AuthorizationException("\u652f\u4ed8\u5b9d\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
        }
        GeneralUserDetails generalUserDetails = user = authentication.isAutoRegister() ? this.userDetailManager.registerOnLoadUserByMobileNotFound(phone) : this.userDetailManager.loadUserByMobile(phone);
        if (user == null) {
            throw new AuthorizationException("\u624b\u673a\u53f7\u9519\u8bef\u6216\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        return user;
    }

    @Override
    public Class<AlipayPhoneAuthenticationToken> getAuthenticationTokenType() {
        return AlipayPhoneAuthenticationToken.class;
    }

    @Override
    public Class<?> getMixinAuthenticationTokenType() {
        return MixinAlipayPhoneAuthenticationToken.class;
    }
}

