/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.mobile_sms;

import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.security.grant.mobile_sms.MobileSmsAuthenticationToken;
import com.elitescloud.boot.auth.provider.security.jackson.mixin.grant.MixinMobileSmsAuthenticationToken;
import com.elitescloud.boot.core.support.verifycode.common.VerifyCodeManager;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class MobileSmsAuthenticationProvider
extends AbstractCustomAuthenticationProvider<MobileSmsAuthenticationToken> {
    private VerifyCodeManager verifyCodeManager;

    @Override
    @NonNull
    protected GeneralUserDetails retrieveUser(MobileSmsAuthenticationToken authentication) throws AuthenticationException {
        GeneralUserDetails user;
        String mobile = (String)authentication.getPrincipal();
        if (!StringUtils.hasText((String)mobile)) {
            throw new AuthorizationException("\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        String smsCode = (String)authentication.getCredentials();
        if (!StringUtils.hasText((String)smsCode)) {
            throw new AuthorizationException("\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        if (authentication.isAutoRegister() && Boolean.FALSE.equals(this.configProperties.getLogin().getAutoRegister())) {
            throw new AuthorizationException("\u4e0d\u652f\u6301\u81ea\u52a8\u6ce8\u518c\u8d26\u53f7");
        }
        String failMsg = this.verifyCodeManager.verify("cloudt_auth_login", mobile, smsCode);
        if (failMsg != null) {
            throw new AuthorizationException("\u624b\u673a\u53f7\u9519\u8bef\u6216\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        GeneralUserDetails generalUserDetails = user = authentication.isAutoRegister() ? this.userDetailManager.registerOnLoadUserByMobileNotFound(mobile) : this.userDetailManager.loadUserByMobile(mobile);
        if (user == null) {
            throw new AuthorizationException("\u624b\u673a\u53f7\u9519\u8bef\u6216\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        return user;
    }

    @Override
    public Class<MobileSmsAuthenticationToken> getAuthenticationTokenType() {
        return MobileSmsAuthenticationToken.class;
    }

    @Override
    public Class<?> getMixinAuthenticationTokenType() {
        return MixinMobileSmsAuthenticationToken.class;
    }

    @Autowired
    public void setVerifyCodeManager(VerifyCodeManager verifyCodeManager) {
        this.verifyCodeManager = verifyCodeManager;
    }
}

