/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.wechat_minapp;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class WechatMinAppAuthenticationToken
extends AbstractCustomAuthenticationToken<WechatMinAppAuthenticationToken> {
    private static final long serialVersionUID = 35697051927011289L;
    private String openId;
    private String unionId;

    public WechatMinAppAuthenticationToken() {
        super(null, null);
    }

    public WechatMinAppAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public WechatMinAppAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    public LoginType loginType() {
        return LoginType.WX_MINAPP;
    }

    public String getOpenId() {
        return this.openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    @NonNull
    public WechatMinAppAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap parameters = HttpServletUtil.getParameters((HttpServletRequest)request);
        String terminalParam = (String)parameters.getFirst((Object)"terminal");
        Terminal terminal = null;
        if (StringUtils.hasText((String)terminalParam)) {
            terminal = Terminal.valueOf((String)terminalParam);
        }
        WechatMinAppAuthenticationToken authenticationToken = new WechatMinAppAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst((Object)"wx_appid"));
        authenticationToken.setCredentials(parameters.getFirst((Object)"wx_code"));
        authenticationToken.setOpenId((String)parameters.getFirst((Object)"wx_openid"));
        authenticationToken.setUnionId((String)parameters.getFirst((Object)"wx_unionid"));
        authenticationToken.setAuthenticated(false);
        authenticationToken.setIdentity((String)parameters.getFirst((Object)"identity"));
        return authenticationToken;
    }
}

