/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.wecom;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.common.LoginAccountType;
import com.elitescloud.boot.auth.provider.provider.wecom.WecomTemplate;
import com.elitescloud.boot.auth.provider.provider.wecom.param.login.Code2UserInfoResult;
import com.elitescloud.boot.auth.provider.provider.wecom.param.login.Ticket2UserDetailResult;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.security.grant.wecom.WecomAuthenticationToken;
import com.elitescloud.boot.auth.provider.security.jackson.mixin.grant.MixinWecomAuthenticationToken;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class WecomAuthenticationProvider
extends AbstractCustomAuthenticationProvider<WecomAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(WecomAuthenticationProvider.class);
    @Autowired
    private WecomTemplate wecomTemplate;

    @Override
    protected GeneralUserDetails retrieveUser(WecomAuthenticationToken authentication) throws AuthenticationException {
        String corpId = (String)authentication.getPrincipal();
        if (!StringUtils.hasText((String)corpId)) {
            throw new AuthorizationException("appId\u4e3a\u7a7a");
        }
        LoginAccountType accountType = authentication.getAccountType();
        if (accountType == null) {
            throw new AuthorizationException("\u8d26\u53f7\u7c7b\u578b\u4e3a\u7a7a");
        }
        String agentId = authentication.getAgentId();
        if (!StringUtils.hasText((String)agentId)) {
            throw new AuthorizationException("\u5e94\u7528ID\u4e3a\u7a7a");
        }
        String code = (String)authentication.getCredentials();
        if (!StringUtils.hasText((String)code)) {
            throw new AuthorizationException("\u6388\u6743\u7801code\u4e3a\u7a7a");
        }
        Code2UserInfoResult code2UserInfoResult = this.wecomTemplate.code2UserInfo(corpId, agentId, code);
        if (!code2UserInfoResult.isSuccess()) {
            throw new AuthorizationException(String.format("\u8c03\u7528\u4f01\u4e1a\u5fae\u4fe1\u670d\u52a1\u5668\u8ba4\u8bc1\u5931\u8d25[%s,%s]", code2UserInfoResult.getErrcode(), code2UserInfoResult.getErrmsg()));
        }
        if (accountType == LoginAccountType.ID || accountType == LoginAccountType.USERNAME) {
            String userId = code2UserInfoResult.getUserid();
            if (CharSequenceUtil.isBlank((CharSequence)userId)) {
                throw new AuthorizationException("\u4f01\u4e1a\u5fae\u4fe1\u8ba4\u8bc1\u5931\u8d25");
            }
            return accountType == LoginAccountType.ID ? this.userDetailManager.loadUserById(userId) : this.userDetailManager.loadUserByUsername(userId);
        }
        if (!StringUtils.hasText((String)code2UserInfoResult.getUser_ticket())) {
            throw new AuthorizationException("\u7528\u6237\u7968\u636e\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u5df2\u6388\u6743\u624b\u673a\u53f7\u6216\u90ae\u7bb1");
        }
        Ticket2UserDetailResult userInfoDetailResult = this.wecomTemplate.getUserByTicket(corpId, agentId, code2UserInfoResult.getUser_ticket());
        if (!userInfoDetailResult.isSuccess()) {
            throw new AuthorizationException(String.format("\u8c03\u7528\u4f01\u4e1a\u5fae\u4fe1\u670d\u52a1\u5668\u8ba4\u8bc1\u5931\u8d25[%s,%s]", code2UserInfoResult.getErrcode(), code2UserInfoResult.getErrmsg()));
        }
        if (accountType == LoginAccountType.MOBILE) {
            if (!StringUtils.hasText((String)userInfoDetailResult.getMobile())) {
                throw new AuthorizationException("\u83b7\u53d6\u4f01\u5fae\u4e2d\u7684\u624b\u673a\u53f7\u5931\u8d25");
            }
            return this.userDetailManager.loadUserByMobile(userInfoDetailResult.getMobile());
        }
        if (accountType == LoginAccountType.EMAIL) {
            String email = CharSequenceUtil.blankToDefault((CharSequence)userInfoDetailResult.getBiz_mail(), (String)userInfoDetailResult.getEmail());
            if (!StringUtils.hasText((String)email)) {
                throw new AuthorizationException("\u83b7\u53d6\u4f01\u5fae\u4e2d\u7684\u90ae\u7bb1\u5931\u8d25");
            }
            return this.userDetailManager.loadUserByEmail(email);
        }
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b" + String.valueOf((Object)accountType));
    }

    @Override
    public Class<WecomAuthenticationToken> getAuthenticationTokenType() {
        return WecomAuthenticationToken.class;
    }

    @Override
    public Class<?> getMixinAuthenticationTokenType() {
        return MixinWecomAuthenticationToken.class;
    }
}

