/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.wecom;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.common.LoginAccountType;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class WecomAuthenticationToken
extends AbstractCustomAuthenticationToken<WecomAuthenticationToken> {
    private static final long serialVersionUID = 3291894847806095884L;
    private static final Logger logger = LoggerFactory.getLogger(WecomAuthenticationToken.class);
    private String agentId;
    private LoginAccountType accountType;

    public WecomAuthenticationToken() {
        super(null, null);
    }

    public WecomAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public WecomAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    public LoginType loginType() {
        return LoginType.WECOM;
    }

    @NonNull
    public WecomAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap parameters = HttpServletUtil.getParameters((HttpServletRequest)request);
        String terminalParam = (String)parameters.getFirst((Object)"terminal");
        Terminal terminal = null;
        if (StringUtils.hasText((String)terminalParam)) {
            terminal = Terminal.valueOf((String)terminalParam);
        }
        WecomAuthenticationToken authenticationToken = new WecomAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst((Object)"wx_appid"));
        authenticationToken.setCredentials(parameters.getFirst((Object)"wx_code"));
        authenticationToken.setAuthenticated(false);
        try {
            authenticationToken.setAccountType(LoginAccountType.valueOf((String)parameters.getFirst((Object)"account_type")));
        }
        catch (Exception e) {
            logger.error("\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b\uff1a{}", parameters.getFirst((Object)"account_type"), (Object)e);
        }
        authenticationToken.setAgentId((String)parameters.getFirst((Object)"wx_agentid"));
        authenticationToken.setIdentity((String)parameters.getFirst((Object)"identity"));
        return authenticationToken;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public LoginAccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(LoginAccountType accountType) {
        this.accountType = accountType;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

