/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.AuthenticationService;
import com.elitescloud.boot.auth.provider.common.param.UserLoginDeviceDTO;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.security.handler.LogoutRedirectHandler;
import com.elitescloud.boot.auth.provider.security.listener.HttpSessionHolder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.boot.util.StrUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

public class DefaultAuthenticationService
implements AuthenticationService {
    private static final Logger log = LogManager.getLogger(DefaultAuthenticationService.class);
    public static final String DEFAULT_SESSION_ID = "JSESSIONID";
    private final DelegateAuthenticationCallable authenticationCallable;
    private final LogoutRedirectHandler logoutRedirectHandler;
    private final AuthenticationCache authenticationCache;

    public DefaultAuthenticationService(DelegateAuthenticationCallable authenticationCallable, LogoutRedirectHandler logoutRedirectHandler, InternalAuthenticationGranter internalAuthenticationGranter, AuthenticationCache authenticationCache) {
        this.authenticationCallable = authenticationCallable;
        this.logoutRedirectHandler = logoutRedirectHandler;
        this.authenticationCache = authenticationCache;
    }

    @Override
    public ApiResult<OAuthToken> attempt(HttpServletRequest request, HttpServletResponse response) {
        Object[] cookies = request.getCookies();
        String cookieValue = null;
        if (ArrayUtil.isNotEmpty((Object[])cookies)) {
            for (Object cookie : cookies) {
                if (!"remember-me".equals(cookie.getName())) continue;
                cookieValue = cookie.getValue();
                break;
            }
        }
        log.info("Cookie\uff1a{}", cookieValue);
        return ApiResult.fail((String)"\u8bf7\u767b\u5f55");
    }

    @Override
    public ApiResult<String> logout(HttpServletRequest request, HttpServletResponse response) {
        String token = SecurityContextUtil.currentToken();
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        String redirectUrl = request.getParameter("redirectUrl");
        if (CharSequenceUtil.isBlank((CharSequence)redirectUrl)) {
            redirectUrl = this.logoutRedirectHandler == null ? null : this.logoutRedirectHandler.determineUrlToUseForThisRequest(request, response);
        }
        String username = null;
        if (StringUtils.hasText((String)token) && user != null) {
            username = user.getUsername();
        }
        this.clearSession(request, response);
        this.authenticationCallable.onLogout(request, response, token, (Object)user);
        if (StringUtils.hasText((String)redirectUrl)) {
            try {
                response.sendRedirect(redirectUrl);
                return null;
            }
            catch (IOException e) {
                log.error(redirectUrl + "\u91cd\u5b9a\u5411\u5f02\u5e38\uff1a", (Throwable)e);
                return ApiResult.fail();
            }
        }
        return ApiResult.ok((Object)username);
    }

    @Override
    public ApiResult<GeneralUserDetails> currentUser() {
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        user.getUser().setPassword("");
        return ApiResult.ok((Object)user);
    }

    @Override
    public ApiResult<List<UserLoginDeviceDTO>> userOnlineDevice(Long userId) {
        if (userId == null) {
            return ApiResult.fail((String)"\u8d26\u6237ID\u4e3a\u7a7a");
        }
        List<UserLoginDeviceDTO> deviceList = this.queryUserDeviceOnline(userId);
        return ApiResult.ok(deviceList);
    }

    @Override
    public ApiResult<Boolean> expiredUserOnlineDevice(Long userId, String clientId) {
        if (userId == null) {
            return ApiResult.fail((String)"\u8d26\u6237ID\u4e3a\u7a7a");
        }
        List<UserLoginDeviceDTO> deviceList = this.queryUserDeviceOnline(userId);
        if (deviceList.isEmpty()) {
            return ApiResult.ok((Object)true);
        }
        for (UserLoginDeviceDTO userLoginDeviceDTO : deviceList) {
            if (!StrUtil.isBlank((CharSequence)clientId) && !clientId.equals(userLoginDeviceDTO.getClientId())) continue;
            this.authenticationCache.removeUserDetail(userLoginDeviceDTO.getToken());
        }
        return ApiResult.ok((Object)true);
    }

    private List<UserLoginDeviceDTO> queryUserDeviceOnline(Long userId) {
        List deviceList = (List)this.authenticationCache.getAttribute(userId.toString() + ":loginDevice");
        if (CollUtil.isEmpty((Collection)deviceList)) {
            return Collections.emptyList();
        }
        return deviceList.stream().filter(t -> this.authenticationCache.exists(t.getToken())).collect(Collectors.toList());
    }

    private void clearSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = null;
        String customSessionId = CharSequenceUtil.blankToDefault((CharSequence)request.getParameter("X-Auth-SID"), (String)request.getHeader("X-Auth-SID"));
        if (StringUtils.hasText((String)customSessionId) && (session = HttpSessionHolder.getSession(customSessionId)) != null) {
            session.invalidate();
        }
        if ((session = request.getSession(false)) != null) {
            session.invalidate();
        }
        SecurityContext context = SecurityContextHolder.getContext();
        SecurityContextHolder.clearContext();
        context.setAuthentication(null);
    }
}

