/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.session.events.AbstractSessionEvent;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionDestroyedEvent;
import org.springframework.session.events.SessionExpiredEvent;

public class SessionEventApplicationListener
implements ApplicationListener<AbstractSessionEvent> {
    private static final Logger logger = LoggerFactory.getLogger(SessionEventApplicationListener.class);

    public void onApplicationEvent(@NonNull AbstractSessionEvent event) {
        logger.info(this.sessionType(event) + "\uff1a{}", (Object)event.getSessionId());
    }

    private String sessionType(AbstractSessionEvent session) {
        if (session instanceof SessionCreatedEvent) {
            return "session\u521b\u5efa";
        }
        if (session instanceof SessionExpiredEvent) {
            return "session\u8fc7\u671f";
        }
        if (session instanceof SessionDeletedEvent) {
            return "session\u5220\u9664";
        }
        if (session instanceof SessionDestroyedEvent) {
            return "session\u9500\u6bc1";
        }
        return "session\u4e8b\u4ef6" + session.getClass().getName();
    }
}

