/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.rememberme;

import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;

public class RedisRememberMeTokenRepository
implements PersistentTokenRepository {
    private final String KEY_PREFIX = "cloudt:auth:rememberMe:";
    private final String URI_VALIDATE_REMEMBER_ME = "/oauth/login/attempt";
    private final RedisHelper redisHelper;
    private final int tokenTtlSeconds;

    public RedisRememberMeTokenRepository(RedisHelper redisHelper, int tokenTtlSeconds) {
        this.redisHelper = redisHelper;
        this.tokenTtlSeconds = tokenTtlSeconds;
    }

    public void createNewToken(PersistentRememberMeToken token) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        HttpServletRequest request = HttpServletUtil.currentRequest();
        CustomPersistentRememberMeToken rememberMeToken = new CustomPersistentRememberMeToken();
        rememberMeToken.setUsername(token.getUsername());
        rememberMeToken.setSeries(token.getSeries());
        rememberMeToken.setTokenValue(token.getTokenValue());
        rememberMeToken.setDate(token.getDate());
        if (authentication instanceof AbstractCustomAuthenticationToken) {
            rememberMeToken.setLoginType(((AbstractCustomAuthenticationToken)authentication).loginType().getType());
        }
        rememberMeToken.setPlatformId((Long)request.getAttribute("cloudtPlatformId"));
        this.redisHelper.execute(redisUtils -> {
            redisUtils.set("cloudt:auth:rememberMe:" + token.getSeries(), (Object)rememberMeToken, (long)this.tokenTtlSeconds, TimeUnit.SECONDS);
            redisUtils.set("cloudt:auth:rememberMe:" + token.getUsername(), (Object)token.getSeries(), (long)this.tokenTtlSeconds, TimeUnit.SECONDS);
            return null;
        });
    }

    public void updateToken(String series, String tokenValue, Date lastUsed) {
        this.redisHelper.execute(redisUtils -> {
            CustomPersistentRememberMeToken rememberMeToken = (CustomPersistentRememberMeToken)redisUtils.get("cloudt:auth:rememberMe:" + series);
            rememberMeToken.setTokenValue(tokenValue);
            rememberMeToken.setDate(lastUsed);
            redisUtils.set("cloudt:auth:rememberMe:" + series, (Object)rememberMeToken, (long)this.tokenTtlSeconds, TimeUnit.SECONDS);
            redisUtils.set("cloudt:auth:rememberMe:" + rememberMeToken.getUsername(), (Object)series, (long)this.tokenTtlSeconds, TimeUnit.SECONDS);
            return null;
        });
    }

    public PersistentRememberMeToken getTokenForSeries(String seriesId) {
        if (!"/oauth/login/attempt".equals(HttpServletUtil.currentRequest().getRequestURI())) {
            return null;
        }
        return null;
    }

    public void removeUserTokens(String username) {
        this.redisHelper.execute(redisUtils -> {
            String series = (String)redisUtils.get("cloudt:auth:rememberMe:" + username);
            if (series == null) {
                return null;
            }
            redisUtils.del(new String[]{"cloudt:auth:rememberMe:" + series, "cloudt:auth:rememberMe:" + username});
            return null;
        });
    }

    public static class CustomPersistentRememberMeToken
    implements Serializable {
        private static final long serialVersionUID = -5659593124002157202L;
        private String username;
        private String series;
        private String tokenValue;
        private Date date;
        private String loginType;
        private Long platformId;

        public String getUsername() {
            return this.username;
        }

        public String getSeries() {
            return this.series;
        }

        public String getTokenValue() {
            return this.tokenValue;
        }

        public Date getDate() {
            return this.date;
        }

        public String getLoginType() {
            return this.loginType;
        }

        public Long getPlatformId() {
            return this.platformId;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setSeries(String series) {
            this.series = series;
        }

        public void setTokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public void setLoginType(String loginType) {
            this.loginType = loginType;
        }

        public void setPlatformId(Long platformId) {
            this.platformId = platformId;
        }
    }
}

