/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.sso2.support.convert;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.common.SsoConvertProperty;
import com.elitescloud.boot.auth.provider.sso2.common.SsoTypeEnum;
import com.elitescloud.boot.auth.provider.sso2.support.convert.BasePlainSsoAuthenticationConvert;
import com.elitescloud.boot.auth.provider.sso2.support.convert.properties.BasicSsoConvertProperty;
import com.elitescloud.boot.auth.provider.sso2.support.convert.properties.JwtSsoConvertProperty;
import com.elitescloud.boot.exception.BusinessException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.Nullable;

public class BasicSsoAuthenticationConvert
extends BasePlainSsoAuthenticationConvert {
    @Override
    public SsoTypeEnum supportType() {
        return SsoTypeEnum.BASIC;
    }

    @Override
    public <T extends SsoConvertProperty> Class<T> propertyType() {
        return BasicSsoConvertProperty.class;
    }

    @Override
    @Nullable
    public <T extends SsoConvertProperty> InternalAuthenticationGranter.InternalAuthenticationToken convert(HttpServletRequest request, HttpServletResponse response, T properties) {
        JwtSsoConvertProperty props = (JwtSsoConvertProperty)properties;
        String value = this.getParam(request, props.getParamName(), props.getParamIn());
        if (CharSequenceUtil.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e3a\u7a7a:" + props.getParamName());
        }
        String username = this.decodeBasicAuth(value);
        if (CharSequenceUtil.isBlank((CharSequence)username)) {
            throw new BusinessException("\u6388\u6743\u8d26\u6237\u4e3a\u7a7a");
        }
        return new InternalAuthenticationGranter.InternalAuthenticationToken(props.getIdType(), username);
    }

    private String decodeBasicAuth(String basicAuth) {
        if (basicAuth.startsWith("Basic ") || basicAuth.startsWith("basic ")) {
            basicAuth = basicAuth.substring(6);
        }
        String credentialsString = new String(Base64.getDecoder().decode(basicAuth.getBytes(StandardCharsets.UTF_8)));
        String[] credentials = credentialsString.split(":");
        return URLDecoder.decode(credentials[0], StandardCharsets.UTF_8);
    }
}

