/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.sso2.support.convert;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.common.SsoConvertProperty;
import com.elitescloud.boot.auth.provider.sso2.common.SsoTypeEnum;
import com.elitescloud.boot.auth.provider.sso2.support.convert.BasePlainSsoAuthenticationConvert;
import com.elitescloud.boot.auth.provider.sso2.support.convert.properties.JwtSsoConvertProperty;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.RsaUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.crypto.AESDecrypter;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.PasswordBasedDecrypter;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtSsoAuthenticationConvert
extends BasePlainSsoAuthenticationConvert {
    private static final Logger logger = LoggerFactory.getLogger(JwtSsoAuthenticationConvert.class);

    @Override
    public SsoTypeEnum supportType() {
        return SsoTypeEnum.JWT;
    }

    @Override
    public <T extends SsoConvertProperty> Class<T> propertyType() {
        return JwtSsoConvertProperty.class;
    }

    @Override
    @Nullable
    public <T extends SsoConvertProperty> InternalAuthenticationGranter.InternalAuthenticationToken convert(HttpServletRequest request, HttpServletResponse response, T properties) {
        JwtSsoConvertProperty props = (JwtSsoConvertProperty)properties;
        String value = this.getParam(request, props.getParamName(), props.getParamIn());
        if (CharSequenceUtil.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e3a\u7a7a:" + props.getParamName());
        }
        Object jwt = null;
        jwt = props.isEncrypt() ? this.parseEncryptedJwt(value, props) : (props.isSigned() ? this.parseSignedJwt(value, props) : this.parsePlainJwt(value));
        String username = null;
        try {
            username = this.obtainUsernameFromJwt((JWT)jwt, props);
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u6790\u4ee4\u724c\u5f02\u5e38", (Throwable)e);
        }
        if (CharSequenceUtil.isBlank((CharSequence)username)) {
            throw new BusinessException("\u6388\u6743\u8d26\u6237\u4e3a\u7a7a");
        }
        return new InternalAuthenticationGranter.InternalAuthenticationToken(props.getIdType(), username);
    }

    private String obtainUsernameFromJwt(JWT jwt, JwtSsoConvertProperty props) throws Exception {
        if (jwt == null) {
            return null;
        }
        if (CharSequenceUtil.isBlank((CharSequence)props.getPayloadUserNamePath())) {
            return jwt.getJWTClaimsSet().getStringClaim(props.getPayloadUserName());
        }
        String payloadUserNamePath = props.getPayloadUserNamePath();
        int dotIndex = payloadUserNamePath.indexOf(".");
        if (dotIndex <= 0) {
            return jwt.getJWTClaimsSet().getStringClaim(payloadUserNamePath);
        }
        String payloadName = payloadUserNamePath.substring(0, dotIndex);
        String path = payloadUserNamePath.substring(dotIndex + 1);
        Map userInfo = (Map)JSONUtil.json2Obj((String)jwt.getJWTClaimsSet().getStringClaim(payloadName), (TypeReference)new TypeReference<Map<String, Object>>(){}, (boolean)true, () -> "\u89e3\u6790\u7528\u6237\u4fe1\u606f\u54cd\u5e94\u5185\u5bb9\u5f02\u5e38");
        return this.getValueByPath(path, userInfo);
    }

    private PlainJWT parsePlainJwt(String jwtValue) {
        PlainJWT jwt = null;
        try {
            jwt = PlainJWT.parse((String)jwtValue);
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u6790\u4ee4\u724c\u5f02\u5e38", (Throwable)e);
        }
        return jwt;
    }

    private SignedJWT parseSignedJwt(String jwtValue, JwtSsoConvertProperty props) {
        Assert.notNull((Object)((Object)props.getSignType()), (String)"\u7b7e\u540d\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)props.getSignKey(), (String)"\u7b7e\u540d\u5bc6\u94a5\u4e3a\u7a7a", (Object[])new Object[0]);
        SignedJWT jwt = null;
        try {
            boolean verified;
            jwt = SignedJWT.parse((String)jwtValue);
            ECDSAVerifier verifier = null;
            switch (props.getSignType()) {
                case HMAC: {
                    OctetSequenceKey jwk = new OctetSequenceKey.Builder(props.getSignKey().getBytes(StandardCharsets.UTF_8)).algorithm((Algorithm)jwt.getHeader().getAlgorithm()).build();
                    verifier = new MACVerifier(jwk);
                    break;
                }
                case RSA: {
                    PublicKey publicKey = "X.509".equals(props.getRsaFormat()) ? RsaUtil.convert2PublicKey((String)props.getSignKey()) : RsaUtil.convert2PublicKeyForPkcs1((String)props.getSignKey());
                    verifier = new RSASSAVerifier((RSAPublicKey)publicKey);
                    break;
                }
                case ECDSA: {
                    ECKey ecKey = ECKey.parse((String)props.getSignKey());
                    verifier = new ECDSAVerifier(ecKey);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u65b9\u5f0f:" + String.valueOf((Object)props.getSignType()));
                }
            }
            boolean bl = verified = verifier == null || jwt.verify(verifier);
            if (!verified) {
                throw new BusinessException("\u4ee4\u724c\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            }
            Date dateExpired = jwt.getJWTClaimsSet().getExpirationTime();
            if (dateExpired != null && dateExpired.before(new Date())) {
                throw new BusinessException("\u4ee4\u724c\u5df2\u8fc7\u671f");
            }
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                throw (BusinessException)e;
            }
            throw new BusinessException("\u89e3\u6790\u4ee4\u724c\u5f02\u5e38", (Throwable)e);
        }
        return jwt;
    }

    private EncryptedJWT parseEncryptedJwt(String jwtValue, JwtSsoConvertProperty props) {
        Assert.notNull((Object)((Object)props.getEncryptType()), (String)"\u52a0\u5bc6\u65b9\u5f0f\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)props.getEncryptKey(), (String)"\u5bc6\u94a5\u4e3a\u7a7a", (Object[])new Object[0]);
        String encryptKey = props.getEncryptKey();
        EncryptedJWT jwt = null;
        try {
            jwt = EncryptedJWT.parse((String)jwtValue);
            switch (props.getEncryptType()) {
                case RSA: {
                    jwt.decrypt((JWEDecrypter)new RSADecrypter(RsaUtil.convert2PrivateKey((String)encryptKey)));
                    break;
                }
                case AES: {
                    jwt.decrypt((JWEDecrypter)new AESDecrypter(encryptKey.getBytes(StandardCharsets.UTF_8)));
                    break;
                }
                case PASSWORD: {
                    jwt.decrypt((JWEDecrypter)new PasswordBasedDecrypter(encryptKey));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u65b9\u5f0f:" + String.valueOf((Object)props.getEncryptType()));
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u6790\u4ee4\u724c\u5f02\u5e38", (Throwable)e);
        }
        return jwt;
    }
}

