package com.elitescloud.boot.auth.provider.common.param;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 微信信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/9/23
 */
@Getter
@Setter
public class WechatApp implements Serializable {
    private static final long serialVersionUID = -6956025585918606011L;

    /**
     * 设置微信的appid
     */
    private String appid;

    /**
     * 设置微信的Secret
     */
    private String secret;

    /**
     * 应用类型
     */
    private WechatAppTypeEnum appType = WechatAppTypeEnum.APPLET;

    /**
     * 扩展配置
     */
    private Map<String, String> properties = new HashMap<>();

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Map<String, String> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public WechatAppTypeEnum getAppType() {
        return appType;
    }

    public void setAppType(WechatAppTypeEnum appType) {
        this.appType = appType;
    }
}
