package com.elitescloud.boot.auth.provider.config;

import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.auth.provider.common.AlipayAppProvider;
import com.elitescloud.boot.auth.provider.common.WechatAppProvider;
import com.elitescloud.boot.auth.provider.common.WecomAppProvider;
import com.elitescloud.boot.auth.provider.config.system.AlipayProperties;
import com.elitescloud.boot.auth.provider.config.properties.AuthorizationProviderProperties;
import com.elitescloud.boot.auth.provider.config.system.WechatProperties;
import com.elitescloud.boot.auth.provider.config.system.WecomProperties;
import com.elitescloud.boot.auth.provider.controller.LoginSupportController;
import com.elitescloud.boot.auth.provider.provider.CaptchaProvider;
import com.elitescloud.boot.auth.provider.provider.LoginSupportProvider;
import com.elitescloud.boot.auth.provider.provider.alipay.AlipayTemplate;
import com.elitescloud.boot.auth.provider.provider.alipay.impl.DefaultAlipayAppProvider;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatTemplate;
import com.elitescloud.boot.auth.provider.provider.wechat.impl.DefaultWechatAppProvider;
import com.elitescloud.boot.auth.provider.provider.wecom.WecomTemplate;
import com.elitescloud.boot.auth.provider.provider.wecom.impl.DefaultWecomAppProvider;
import com.elitescloud.boot.core.CloudtCoreAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

/**
 * 可选登录扩展支持配置.
 * <p>
 * 根据登录认证方式选择
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/6
 */
@ConditionalOnClass({CloudtCoreAutoConfiguration.class})
public class LoginSupportConfig {

    private final AuthorizationProviderProperties configProperties;

    public LoginSupportConfig(AuthorizationProviderProperties configProperties) {
        this.configProperties = configProperties;
    }

    /**
     * 登录基础支持服务
     *
     * @return
     */
    @Bean
    public LoginSupportProvider loginSupportProvider() {
        return new LoginSupportProvider(configProperties);
    }

    /**
     * 登录相关基础支持服务接口
     *
     * @param loginSupportProvider
     * @return
     */
    @Bean
    public LoginSupportController commonLoginSupportController(LoginSupportProvider loginSupportProvider) {
        return new LoginSupportController(loginSupportProvider);
    }

    /**
     * 验证码相关服务
     *
     * @param redisHelper
     * @return
     */
    @Bean
    public CaptchaProvider captchaProvider(RedisHelper redisHelper) {
        return new CaptchaProvider(redisHelper);
    }

    @Bean
    public WechatAppProvider defaultWechatAppProvider(WechatProperties wechatProperties) {
        return new DefaultWechatAppProvider(wechatProperties);
    }

    /**
     * 微信相关服务
     *
     * @param redisHelper
     * @return
     */
    @Bean
    public WechatTemplate wechatTemplate(RedisHelper redisHelper,
                                         WechatAppProvider wechatAppProvider) {
        return new WechatTemplate(wechatAppProvider, redisHelper);
    }

    @Bean
    public WecomAppProvider defaultWecomAppProvider(WecomProperties wecomProperties) {
        return new DefaultWecomAppProvider(wecomProperties);
    }

    /**
     * 企业微信
     *
     * @param redisHelper
     * @param appProvider
     * @return
     */
    @Bean
    public WecomTemplate wecomTemplate(RedisHelper redisHelper,
                                       WecomAppProvider appProvider) {
        return new WecomTemplate(appProvider, redisHelper);
    }

    @Bean
    public AlipayAppProvider defaultAlipayAppProvider(AlipayProperties properties) {
        return new DefaultAlipayAppProvider(properties);
    }

    @Bean
    public AlipayTemplate alipayTemplate(AlipayAppProvider alipayAppProvider,
                                         RedisHelper redisHelper) {
        return new AlipayTemplate(alipayAppProvider, redisHelper);
    }
}
