package com.elitescloud.boot.auth.provider.provider;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.provider.config.properties.TokenProperties;
import com.elitescloud.boot.auth.provider.security.TokenPropertiesProvider;
import lombok.extern.slf4j.Slf4j;

/**
 * 默认的token配置提供者.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/17
 */
@Slf4j
public class DefaultTokenPropertiesProvider implements TokenPropertiesProvider {

    private final AuthorizationProperties authorizationProperties;

    public DefaultTokenPropertiesProvider(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
        log.info("Default token configuration will be used");
    }

    @Override
    public TokenProperties get() {
        TokenProperties properties = new TokenProperties();
        properties.setTokenTtl(authorizationProperties.getTokenTtl());
        properties.setRefreshTokenTtl(authorizationProperties.getRefreshTokenTtl());
        return properties;
    }
}
