package com.elitescloud.boot.auth.provider.security.grant.alipay_minapp;

import cn.hutool.core.text.CharSequenceUtil;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.provider.alipay.AlipayTemplate;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.security.grant.alipay_phone.AlipayPhoneAuthenticationToken;
import com.elitescloud.boot.auth.provider.security.jackson.mixin.grant.MixinAlipayMinappAuthenticationToken;
import com.elitescloud.boot.auth.provider.security.jackson.mixin.grant.MixinAlipayPhoneAuthenticationToken;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

/**
 * 支付宝手机号的身份认证.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
@Log4j2
public class AlipayMinappAuthenticationProvider extends AbstractCustomAuthenticationProvider<AlipayMinappAuthenticationToken> {

    @Autowired
    private AlipayTemplate alipayTemplate;

    @Override
    protected GeneralUserDetails retrieveUser(AlipayMinappAuthenticationToken authentication) throws AuthenticationException {
        String appId = (String) authentication.getPrincipal();
        if (!StringUtils.hasText(appId)) {
            throw new AuthorizationException("应用ID为空");
        }

        if (StringUtils.hasText(authentication.getOpenId())) {
            var user = userDetailManager.loadUserByOpenId(appId, authentication.getOpenId());
            if (user == null) {
                throw new UsernameNotFoundException("暂未绑定该支付宝账号");
            }
            return user;
        }

        String resp = (String) authentication.getCredentials();
        if (!StringUtils.hasText(resp)) {
            throw new AuthorizationException("支付宝授权内容为空");
        }

        AlipaySystemOauthTokenResponse tokenResponse = alipayTemplate.oauthToken(appId, resp);
        if (tokenResponse == null) {
            throw new AuthorizationException("支付宝授权异常");
        }
        var openId = authentication.isPreferUserId() ? tokenResponse.getUserId() : tokenResponse.getOpenId();
        if (CharSequenceUtil.isBlank(openId)) {
            throw new AuthorizationException("支付宝授权失败");
        }

        var user = userDetailManager.loadUserByOpenId(appId, openId);
        if (user == null) {
            throw new UsernameNotFoundException("暂未绑定该支付宝账号");
        }
        return user;
    }

    @Override
    public Class<AlipayMinappAuthenticationToken> getAuthenticationTokenType() {
        return AlipayMinappAuthenticationToken.class;
    }

    @Override
    public Class<?> getMixinAuthenticationTokenType() {
        return MixinAlipayMinappAuthenticationToken.class;
    }
}
