package com.elitescloud.boot.auth.provider.security.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.session.events.*;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/3
 */
public class SessionEventApplicationListener implements ApplicationListener<AbstractSessionEvent> {
    private static final Logger logger = LoggerFactory.getLogger(SessionEventApplicationListener.class);

    @Override
    public void onApplicationEvent(@NonNull AbstractSessionEvent event) {
        logger.info(sessionType(event) + "：{}", event.getSessionId());
    }

    private String sessionType(AbstractSessionEvent session) {
        if (session instanceof SessionCreatedEvent) {
            return "session创建";
        }
        if (session instanceof SessionExpiredEvent) {
            return "session过期";
        }
        if (session instanceof SessionDeletedEvent) {
            return "session删除";
        }
        if (session instanceof SessionDestroyedEvent) {
            return "session销毁";
        }
        return "session事件" + session.getClass().getName();
    }
}
