package com.elitescloud.boot.auth.provider.security.rememberme;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.provider.common.AuthorizationConstant;
import com.elitescloud.boot.auth.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

/**
 * 获取用户信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/13
 */
public class RememberMeUserDetailService implements UserDetailsService {

    private final UserDetailManager userDetailsManager;

    public RememberMeUserDetailService(UserDetailManager userDetailsManager) {
        this.userDetailsManager = userDetailsManager;
    }

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        var request = HttpServletUtil.currentRequest();
        var loginType = (String) request.getAttribute(AuthorizationConstant.REQUEST_ATTRIBUTE_LOGIN_TYPE);
        if (CharSequenceUtil.isBlank(loginType)) {
            throw new AuthorizationException("未知登录类型");
        }

        if (loginType.equals(LoginType.PASSWORD.getType())) {
            return userDetailsManager.loadUserByUsername(username);
        }
        if (loginType.equals(LoginType.MOBILE_PWD.getType())) {
            return userDetailsManager.loadUserByMobile(username);
        }
        if (loginType.equals(LoginType.EMAIL_PWD.getType())) {
            return userDetailsManager.loadUserByEmail(username);
        }
        if (loginType.equals(LoginType.ACCOUNT_PWD.getType())) {
            return userDetailsManager.loadUserByAccount(username);
        }

        throw new AuthorizationException("暂不支持的登录类型" + loginType);
    }
}
