package com.elitescloud.boot.auth.provider.sso2.controller;

import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.sso2.support.SsoClientSupportProvider;
import com.elitescloud.boot.auth.provider.sso2.support.SsoUnifyClientSupportProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;

/**
 * 单点登录支持接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/2/20
 */
@ResponseBody
@RequestMapping(value = "/oauth/sso/v2", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(tags = {"单点登录"})
public class SsoUnifyClientSupportController {

    private final SsoUnifyClientSupportProvider ssoSupportProvider;

    public SsoUnifyClientSupportController(SsoUnifyClientSupportProvider ssoSupportProvider) {
        this.ssoSupportProvider = ssoSupportProvider;
    }

    @ApiOperation(value = "获取认证token")
    @ApiOperationSupport(order = 31)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ac", value = "认证编码", required = true),
    })
    @RequestMapping(value = "/auth", method = {RequestMethod.GET, RequestMethod.POST})
    public ApiResult<OAuthToken> auth(HttpServletRequest request, HttpServletResponse response) {
        return ssoSupportProvider.authenticate(request, response);
    }
}
