package com.elitescloud.boot.auth.provider.sso2.support.convert;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.boot.auth.provider.sso2.common.SsoAuthenticationConvert;
import com.elitescloud.boot.common.ParamIn;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/6 周五
 */
public abstract class BasePlainSsoAuthenticationConvert implements SsoAuthenticationConvert {

    protected String getParam(HttpServletRequest request, String paramName, ParamIn paramIn) {
        if (paramIn == null || CharSequenceUtil.isBlank(paramName)) {
            return null;
        }

        switch (paramIn) {
            case QUERY:
            case FORM:
                return request.getParameter(paramName);
            case HEADER:
                return request.getHeader(paramName);
            case COOKIE:
                var cookies = request.getCookies();
                if (ArrayUtil.isEmpty(cookies)) {
                    return null;
                }
                for (Cookie cookie : cookies) {
                    if (paramName.equalsIgnoreCase(cookie.getName())) {
                        return cookie.getValue();
                    }
                }
            default:
                throw new IllegalArgumentException("暂不支持的参数位置：" + paramIn);
        }
    }

    protected String getValueByPath(String path, Map<String, Object> jsonResp) {
        if (CollUtil.isEmpty(jsonResp) || CharSequenceUtil.isBlank(path)) {
            return null;
        }

        String[] paramPath = path.split("\\.");
        Map<String, Object> tempObj = jsonResp;
        Object tempValue = null;
        for (int i = 0; i < paramPath.length; i++) {
            tempValue = tempObj.get(paramPath[i]);
            if (tempValue == null) {
                break;
            }
            if (i == paramPath.length - 1) {
                return tempValue.toString();
            }
            if (tempValue instanceof Map) {
                tempObj = (Map<String, Object>) tempValue;
                continue;
            }
            break;
        }

        return null;
    }
}
