package com.elitescloud.boot.auth.cas.config;

import com.elitescloud.boot.auth.config.CloudtOAuth2ClientProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.io.Serializable;
import java.time.Duration;

/**
 * CAS客户端.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/3
 */
public class CasClientProperties implements Serializable {
    private static final long serialVersionUID = -3709055985972852554L;

    /**
     * 是否启用
     */
    private Boolean enabled = false;

    /**
     * 是否支持校验密码
     */
    private Boolean supportValidatePassword = true;

    /**
     * OAuth2客户端信息
     */
    @NestedConfigurationProperty
    private CloudtOAuth2ClientProperties oauth2Client = new CloudtOAuth2ClientProperties();

    /**
     * 是否在同步信息失败时抛出异常
     * 默认false，不影响原主流程，业务可使用该字段
     */
    private Boolean syncFailThrow = false;

    /**
     * 出现异常，是否回滚所有
     * 出现异常时，批量处理的对象是否都回滚
     */
    private Boolean rollBackAllOnException = false;

    /**
     * 自动同步间隔
     */
    private Duration syncInterval = Duration.ofMinutes(30);

    /**
     * 客户端token刷新间隔
     */
    private Duration clientTokenInterval = Duration.ofMinutes(20);

    /**
     * 每次同步用户量
     */
    private Integer syncSize = 10;

    /**
     * 是否支持用户加密的密码
     */
    private Boolean supportEncodedPassword = false;

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getSupportValidatePassword() {
        return supportValidatePassword;
    }

    public void setSupportValidatePassword(Boolean supportValidatePassword) {
        this.supportValidatePassword = supportValidatePassword;
    }

    public CloudtOAuth2ClientProperties getOauth2Client() {
        return oauth2Client;
    }

    public void setOauth2Client(CloudtOAuth2ClientProperties oauth2Client) {
        this.oauth2Client = oauth2Client;
    }

    public Boolean getSyncFailThrow() {
        return syncFailThrow;
    }

    public void setSyncFailThrow(Boolean syncFailThrow) {
        this.syncFailThrow = syncFailThrow;
    }

    public Boolean getRollBackAllOnException() {
        return rollBackAllOnException;
    }

    public void setRollBackAllOnException(Boolean rollBackAllOnException) {
        this.rollBackAllOnException = rollBackAllOnException;
    }

    public Duration getSyncInterval() {
        return syncInterval;
    }

    public void setSyncInterval(Duration syncInterval) {
        this.syncInterval = syncInterval;
    }

    public Duration getClientTokenInterval() {
        return clientTokenInterval;
    }

    public void setClientTokenInterval(Duration clientTokenInterval) {
        this.clientTokenInterval = clientTokenInterval;
    }

    public Integer getSyncSize() {
        return syncSize;
    }

    public void setSyncSize(Integer syncSize) {
        this.syncSize = syncSize;
    }

    public Boolean getSupportEncodedPassword() {
        return supportEncodedPassword;
    }

    public void setSupportEncodedPassword(Boolean supportEncodedPassword) {
        this.supportEncodedPassword = supportEncodedPassword;
    }
}
