package com.elitescloud.boot.auth.cas.model;

import com.elitescloud.boot.auth.common.AuthSdkConstant;
import org.springframework.security.oauth2.core.endpoint.OAuth2ParameterNames;
import org.springframework.security.oauth2.core.endpoint.PkceParameterNames;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.Serializable;
import java.net.URI;
import java.util.Optional;

/**
 * 认证信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/11
 */
public class AuthorizeDTO implements Serializable {
    private static final long serialVersionUID = -1959826592986980733L;

    /**
     * 认证地址
     */
    private String authorizeEndpoint;
    /**
     * 客户端ID
     */
    private String clientId;
    /**
     * 响应类型
     */
    private String responseType;

    /**
     * 授权范围
     */
    private String scope;
    /**
     * 重定向路径
     */
    private String redirectUri;
    /**
     * 验证码
     */
    private String codeVerifier;
    /**
     * 加密方式
     */
    private String codeChallengeMethod;
    /**
     * 加密值
     */
    private String codeChallenge;
    /**
     * 客户端自定义参数
     */
    private String state;
    /**
     * 认证服务地址
     */
    private String authServer;
    /**
     * 服务路由
     */
    private String serverRouter;
    /**
     * 注销URL
     */
    private String logoutUrl;

    public String getAuthorizeEndpoint() {
        return authorizeEndpoint;
    }

    public void setAuthorizeEndpoint(String authorizeEndpoint) {
        this.authorizeEndpoint = authorizeEndpoint;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getResponseType() {
        return responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getRedirectUri() {
        return redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getCodeVerifier() {
        return codeVerifier;
    }

    public void setCodeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
    }

    public String getCodeChallengeMethod() {
        return codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getCodeChallenge() {
        return codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getAuthServer() {
        return authServer;
    }

    public void setAuthServer(String authServer) {
        this.authServer = authServer;
    }

    public String getServerRouter() {
        return serverRouter;
    }

    public void setServerRouter(String serverRouter) {
        this.serverRouter = serverRouter;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getLogoutUrl() {
        return logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public String getUrl() {
        String url = null;
        if (StringUtils.hasText(getAuthServer()) && getAuthorizeEndpoint().startsWith(getAuthServer())) {
            url = getAuthorizeEndpoint();
        } else {
            String path = URI.create(getAuthorizeEndpoint()).getPath();
            if (StringUtils.hasText(getServerRouter()) && path.startsWith(getServerRouter())) {
                path = path.substring(getServerRouter().length());
            }
            url = getAuthServer() + path;
        }
        return UriComponentsBuilder.fromUriString(url)
                .queryParamIfPresent(OAuth2ParameterNames.CLIENT_ID, Optional.ofNullable(getClientId()))
                .queryParamIfPresent(OAuth2ParameterNames.RESPONSE_TYPE, Optional.ofNullable(getResponseType()))
                .queryParamIfPresent(OAuth2ParameterNames.SCOPE, Optional.ofNullable(getScope()))
                .queryParamIfPresent(OAuth2ParameterNames.REDIRECT_URI, Optional.ofNullable(getRedirectUri()))
                .queryParamIfPresent(PkceParameterNames.CODE_CHALLENGE_METHOD, Optional.ofNullable(getCodeChallengeMethod()))
                .queryParamIfPresent(PkceParameterNames.CODE_CHALLENGE, Optional.ofNullable(getCodeChallenge()))
                .queryParamIfPresent(OAuth2ParameterNames.STATE, Optional.ofNullable(getState()))
                .queryParamIfPresent(AuthSdkConstant.OAUTH2_AUTHORIZE_PARAM_AUTH_SERVER, Optional.ofNullable(getAuthServer()))
                .toUriString();
    }
}
