package com.elitescloud.boot.auth.cas.provider;

import java.net.URI;

/**
 * url常量.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/16
 */
interface CasUrlConstant {
    /**
     * 认证元数据
     */
    String URI_AUTHORIZATION_METADATA = "/.well-known/oauth-authorization-server";
    /**
     * OIDC元数据
     */
    String URI_OIDC_METADATA = "/.well-known/openid-configuration";

    /**
     * API接口前缀
     */
    String URI_API_PREFIX = "/rpc/cloudt/authorization";

    /**
     * 同步用户接口
     */
    String URI_USER_UPSERT = URI_API_PREFIX + "/user/upsertUser";
    /**
     * 批量同步用户接口
     */
    String URI_USER_UPSERT_BATCH = URI_API_PREFIX + "/user/upsertUser/batch?rollBackAllOnException={rollBackAllOnException}";
    /**
     * 修改用户状态接口
     */
    String URI_USER_UPDATE_ENABLED = URI_API_PREFIX + "/user/update/enabled?userId={userId}&enabled={enabled}";
    /**
     * 解锁用户
     */
    String URI_USER_UNLOCK = URI_API_PREFIX + "/user/unLock?userId={userId}";

    /**
     * 获取锁定信息
     */
    String URI_USER_LOCK_INFO = URI_API_PREFIX + "/user/lockInfo?userId={userId}";
    /**
     * 修改用户密码接口
     */
    String URI_USER_UPDATE_PWD = URI_API_PREFIX + "/user/update/pwd?userId={userId}&pd={pd}";
    String URI_USER_UPDATE_PWD_V1 = URI_API_PREFIX + "/user/update/pwd/v1";
    /**
     * 密码校验
     */
    String URI_USER_VERIFY_PASSWORD = URI_API_PREFIX + "/user/validate/pwd?userId={userId}&pwd={pwd}&pwdNew={pwdNew}";
    /**
     * 密码校验
     */
    String URI_USER_VERIFY_PASSWORD_V1 = URI_API_PREFIX + "/user/validate/pwd/v1?userId={userId}&pwd={pwd}";
    /**
     * 修改手机号
     */
    String URI_USER_UPDATE_MOBILE = URI_API_PREFIX + "/user/update/mobile?id={id}&mobile={mobile}";
    /**
     * 修改邮箱
     */
    String URI_USER_UPDATE_EMAIL = URI_API_PREFIX + "/user/update/email?id={id}&email={email}";
    /**
     * 更新账号过期时间
     */
    String URI_USER_UPDATE_EXPIRED_TIME = URI_API_PREFIX + "/user/update/expiredTime?userId={userId}&expiredTime={expiredTime}";
    /**
     * 更新账号的密码过期时间
     */
    String URI_USER_UPDATE_PWD_EXPIRED_TIME = URI_API_PREFIX + "/user/update/pwd/expiredTime?userId={userId}&expiredTime={expiredTime}";
    /**
     * 删除用户
     */
    String URI_USER_DELETE = URI_API_PREFIX + "/user/delete?userId={userId}";
    /**
     * 根据ID获取单个用户
     */
    String URI_USER_GET = URI_API_PREFIX + "/user/getUser?userId={userId}";
    /**
     * 根据登录号获取单个用户
     */
    String URI_USER_GET_BY_USERNAME = URI_API_PREFIX + "/user/getUserByUsername?username={username}";
    /**
     * 根据手机号获取单个用户
     */
    String URI_USER_GET_BY_MOBILE = URI_API_PREFIX + "/user/getUserByMobile?mobile={mobile}";
    /**
     * 根据邮箱获取单个用户
     */
    String URI_USER_GET_BY_EMAIL = URI_API_PREFIX + "/user/getUserByEmail?email={email}";
    /**
     * 获取多个用户
     */
    String URI_USER_LIST = URI_API_PREFIX + "/user/getUserList";
    /**
     * 获取多个用户
     */
    String URI_USER_QUERY = URI_API_PREFIX + "/user/queryUserList";
    /**
     * 根据账号获取ID
     */
    String URI_USER_ID_BY_USERNAME = URI_API_PREFIX + "/user/getUserIdByUsername";
    /**
     * 根据手机号获取ID
     */
    String URI_USER_ID_BY_MOBILE = URI_API_PREFIX + "/user/getUserIdByMobile";
    /**
     * 根据邮箱获取ID
     */
    String URI_USER_ID_BY_EMAIL = URI_API_PREFIX + "/user/getUserIdByEmail";
    /**
     * 校验客户端用户信息
     */
    String URI_CLIENT_USER_VALIDATE = URI_API_PREFIX + "/user/validateClientUser?clientId={clientId}&userId={userId}";
    /**
     * 登录校验
     */
    String URI_USER_VALIDATE = URI_API_PREFIX + "/user/validateLogin?userId={userId}&pwd={pwd}";

    /**
     * 分页查询登录日志
     */
    String URI_LOGIN_LOG_PAGE = URI_API_PREFIX + "/loginLog/page";

    /**
     * 同步第三方账号-微信服务号
     */
    String URI_THIRD_PARTY_UPSERT_WECHAT_SERVICE = URI_API_PREFIX + "/third_party/wechat/upsertService";
    /**
     * 同步第三方账号-微信小程序
     */
    String URI_THIRD_PARTY_UPSERT_WECHAT_MINI = URI_API_PREFIX + "/third_party/wechat/upsertMiniProgram";
    /**
     * 同步第三方账号-微信订阅号
     */
    String URI_THIRD_PARTY_UPSERT_WECHAT_SUBSCRIPTION = URI_API_PREFIX + "/third_party/wechat/upsertSubscription";
    /**
     * 同步第三方账号的启用状态
     */
    String URI_THIRD_PARTY_UPDATE_ENABLED = URI_API_PREFIX + "/third_party/update/enabled?accountId={accountId}&enabled={enabled}";
    /**
     * 删除第三方账号
     */
    String URI_THIRD_PARTY_DELETE = URI_API_PREFIX + "/third_party/delete?accountId={accountId}";
    /**
     * 获取配置的密码策略
     */
    String URI_PWD_STRATEGY_GET = URI_API_PREFIX + "/pwdStrategy/get";
    /**
     * 获取默认的密码策略
     */
    String URI_PWD_STRATEGY_GET_DEFAULT = URI_API_PREFIX + "/pwdStrategy/getDefault";
    /**
     * 保存密码策略
     */
    String URI_PWD_STRATEGY_SAVE = URI_API_PREFIX + "/pwdStrategy/save";
    /**
     * 根据类型获取密码策略列表
     */
    String URI_PWD_STRATEGY_LIST_BY_TYPE = URI_API_PREFIX + "/pwdStrategy/listByType?type={type}";
    /**
     * 校验密码
     */
    String URI_PWD_STRATEGY_VERIFY = URI_API_PREFIX + "/pwdStrategy/verify?userId={userId}&username={username}&p={p}";
    /**
     * 获取登录用户扩展信息
     */
    String URI_PWD_USER_DETAIL_EXTEND = URI_API_PREFIX + "/pwdStrategy/userDetailExtend?userId={userId}";
    /**
     * 校验客户端密码
     */
    String URI_CLIENT_VALIDATE = URI_API_PREFIX + "/client/validateClient?clientId={clientId}&clientSecret={clientSecret}";

    /**
     * 是否需要token
     *
     * @param uri uri
     * @return 是否需要token
     */
    static boolean needToken(URI uri) {
        String path = uri.getPath();
        // 去掉context-path
        if (path.startsWith("/cloudt/authorization")) {
            path = path.substring("/cloudt/authorization".length());
        } else if (path.startsWith("/cloudt-authorization")) {
            path = path.substring("/cloudt-authorization".length());
        }

        if ("/rpc/cloudt/authorization/user/validateClientUser".equals(path)) {
            return false;
        }
        return true;
    }
}
