package com.elitescloud.boot.auth.cas.task;

import com.elitescloud.boot.auth.cas.provider.OAuth2ClientTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

/**
 * 自动刷新客户端token.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/15
 */
public class AutoRefreshClientTokenTask implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AutoRefreshClientTokenTask.class);
    private static final int MAX_RETRY_TIMES = 5;
    private final OAuth2ClientTemplate oAuth2ClientTemplate;

    public AutoRefreshClientTokenTask(OAuth2ClientTemplate oAuth2ClientTemplate) {
        this.oAuth2ClientTemplate = oAuth2ClientTemplate;
        ClientTokenHolder.setTokenSupplier(() -> oAuth2ClientTemplate.clientToken());
    }

    @Override
    public void run() {
        var result = this.execute();
        if (result) {
            return;
        }

        // 失败后重试
        int retryTimes = 0;
        while (retryTimes < MAX_RETRY_TIMES) {
            try {
                TimeUnit.MINUTES.sleep(retryTimes + 1);
            } catch (InterruptedException ignored) {
            }

            LOG.debug("第{}次尝试重新获取客户端token", retryTimes);
            result = this.execute();
            if (result) {
                // 获取成功
                break;
            }
            retryTimes++;
        }

    }

    private boolean execute() {
        var tokenResult = oAuth2ClientTemplate.clientToken();
        if (tokenResult != null) {
            ClientTokenHolder.setToken(tokenResult);
            LOG.debug("客户端token刷新：{}", tokenResult);
            return true;
        }

        LOG.error("CAS客户端token获取失败：{}", tokenResult);
        return false;
    }
}
