/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.provider.impl;

import com.elitescloud.boot.auth.cas.AuthorizeCacheable;
import com.elitescloud.boot.auth.cas.model.AuthorizeDTO;
import com.elitescloud.boot.auth.cas.model.OAuth2UserInfoDTO;
import com.elitescloud.boot.auth.cas.provider.OAuth2ClientTemplate;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.config.CloudtOAuth2ClientProperties;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.resolver.UniqueRequestResolver;
import com.elitescloud.boot.auth.resolver.impl.DefaultUniquestResolver;
import com.elitescloud.boot.auth.util.AuthSdkUtil;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DefaultOAuth2ClientTemplate
implements OAuth2ClientTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOAuth2ClientTemplate.class);
    protected static final String PARAM_REDIRECT_URL = "redirectUrl";
    protected static final String PARAM_STATE = "state";
    protected static final String PARAM_AUTH_SERVER = "authServer";
    private final AuthorizationSdkProperties sdkProperties;
    private final AuthorizeCacheable authorizeCacheable;
    protected ObjectMapper objectMapper = ObjectMapperFactory.instance();
    protected UniqueRequestResolver uniqueRequestResolver = new DefaultUniquestResolver("X-Auth-Cas-Client");
    protected RestTemplate restTemplate = RestTemplateFactory.dynamicInstance(null, (String[])new String[]{"cloudt-authorization"});
    private final Map<String, EndpointInfo> endpointInfoMap = new HashMap<String, EndpointInfo>(4);
    private final Map<String, CloudtOAuth2ClientProperties> clientPropertiesMap = new HashMap<String, CloudtOAuth2ClientProperties>(4);

    public DefaultOAuth2ClientTemplate(AuthorizationSdkProperties sdkProperties, AuthorizeCacheable authorizeCacheable) {
        this.sdkProperties = sdkProperties;
        this.authorizeCacheable = authorizeCacheable == null ? new AuthorizeCacheDefault() : authorizeCacheable;
    }

    @Override
    public AuthorizeDTO generateAuthorizeInfo(HttpServletRequest request, @NotNull HttpServletResponse response) {
        CloudtOAuth2ClientProperties clientProperties = this.detectOAuth2ClientProperties(request);
        Assert.notNull((Object)clientProperties, (String)"OAuth2\u5ba2\u6237\u7aef\u672a\u914d\u7f6e");
        this.clientPropertiesMap.put(clientProperties.getClientId(), clientProperties);
        EndpointInfo endpointInfo = this.endpointInfoMap.get(clientProperties.getClientId());
        if (endpointInfo == null) {
            endpointInfo = this.buildEndpointInfo(clientProperties);
            if (endpointInfo == null) {
                throw new OAuth2AuthenticationException("OAuth2\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u914d\u7f6e");
            }
            this.endpointInfoMap.put(clientProperties.getClientId(), endpointInfo);
        }
        AuthorizeDTO authorizeDTO = new AuthorizeDTO();
        authorizeDTO.setAuthorizeEndpoint(endpointInfo.getAuthorizeEndpoint());
        authorizeDTO.setClientId(clientProperties.getClientId());
        authorizeDTO.setResponseType("code");
        authorizeDTO.setScope("openid");
        authorizeDTO.setRedirectUri(this.obtainRedirectUrl(request, clientProperties));
        if (this.sdkProperties.getCasClient().getOauth2Client().isPkceEnabled()) {
            authorizeDTO.setCodeVerifier(AuthSdkUtil.generateCodeVerifier());
            authorizeDTO.setCodeChallengeMethod("S256");
            authorizeDTO.setCodeChallenge(AuthSdkUtil.generateCodeChallenge(authorizeDTO.getCodeVerifier()));
        }
        authorizeDTO.setAuthServer(this.detectServerAddr(request, clientProperties, endpointInfo.getServerAddr()));
        authorizeDTO.setServerRouter(clientProperties.getDetectServerAddrRouter());
        authorizeDTO.setState(request.getParameter(PARAM_STATE));
        authorizeDTO.setLogoutUrl(this.normalizeEndpoint(authorizeDTO.getAuthServer(), this.buildLogoutUri(clientProperties, authorizeDTO.getRedirectUri())));
        String reqId = this.uniqueRequestResolver.signRequest(response);
        this.authorizeCacheable.setCache(reqId, authorizeDTO);
        return authorizeDTO;
    }

    @Override
    public OAuthToken code2Token(HttpServletRequest request, HttpServletResponse response, String code) {
        String redirectUri;
        String reqId = this.uniqueRequestResolver.analyze(request);
        AuthorizeDTO authorizedInfo = null;
        if (StringUtils.hasText((String)reqId)) {
            authorizedInfo = this.authorizeCacheable.get(reqId);
        }
        CloudtOAuth2ClientProperties clientProperties = null;
        if (authorizedInfo != null) {
            clientProperties = this.clientPropertiesMap.get(authorizedInfo.getClientId());
        }
        if (clientProperties == null) {
            LOG.info("\u672a\u83b7\u53d6\u5230\u5df2\u8ba4\u8bc1\u4fe1\u606f\uff0c\u5c1d\u8bd5\u83b7\u53d6\u9ed8\u8ba4\u914d\u7f6e\u4fe1\u606f...");
            clientProperties = this.detectOAuth2ClientProperties(request);
        }
        if (clientProperties == null) {
            LOG.info("\u83b7\u53d6\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff1a{}\uff0c\u6216\u5df2\u8d85\u65f6", (Object)reqId);
            throw new OAuth2AuthenticationException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        EndpointInfo endpointInfo = this.endpointInfoMap.get(clientProperties.getClientId());
        if (endpointInfo == null) {
            endpointInfo = this.buildEndpointInfo(clientProperties);
        }
        LinkedMultiValueMap postParam = new LinkedMultiValueMap(8);
        postParam.add((Object)"client_id", (Object)clientProperties.getClientId());
        postParam.add((Object)"client_secret", (Object)clientProperties.getClientSecret());
        postParam.add((Object)"grant_type", (Object)AuthorizationGrantType.AUTHORIZATION_CODE.getValue());
        postParam.add((Object)"code", (Object)code);
        String string = redirectUri = authorizedInfo == null ? clientProperties.getRedirectUrl() : authorizedInfo.getRedirectUri();
        if (StringUtils.hasText((String)redirectUri)) {
            LOG.info("redirectUri\uff1a{}", (Object)redirectUri);
            postParam.add((Object)"redirect_uri", (Object)redirectUri);
        }
        if (authorizedInfo != null && StringUtils.hasText((String)authorizedInfo.getCodeVerifier())) {
            LOG.info("codeVerifier\uff1a{}", (Object)authorizedInfo.getCodeVerifier());
            postParam.add((Object)"code_verifier", (Object)authorizedInfo.getCodeVerifier());
        }
        try {
            ResponseEntity resp = this.restTemplate.exchange(endpointInfo.getTokenEndpoint(), HttpMethod.POST, new HttpEntity((Object)postParam), (ParameterizedTypeReference)new ParameterizedTypeReference<HashMap<String, Object>>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                this.uniqueRequestResolver.clear(response, reqId);
                return this.convertAuthToken((Map)resp.getBody());
            }
            LOG.error("\u6388\u6743\u7801\u8f6ctoken\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u54cd\u5e94\uff1a{}", (Object)this.objectMapper.writeValueAsString((Object)postParam), (Object)resp);
            if (resp.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                throw new OAuth2AuthenticationException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof OAuth2AuthenticationException) {
                throw (OAuth2AuthenticationException)e;
            }
            try {
                LOG.error("\u83b7\u53d6\u8ba4\u8bc1token\u5f02\u5e38\uff0c\u53c2\u6570\uff1a" + this.objectMapper.writeValueAsString((Object)postParam) + ", \uff1a", (Throwable)e);
            }
            catch (JsonProcessingException ex) {
                LOG.error("\u83b7\u53d6\u8ba4\u8bc1token\u5f02\u5e38\uff0c\u6253\u5370\u5165\u53c2\u5f02\u5e38\uff0c", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public OAuth2UserInfoDTO getUserInfo(HttpServletRequest request, String tokenType, String token) {
        Assert.hasText((String)tokenType, (String)"token\u7c7b\u578b\u4e3a\u7a7a");
        Assert.hasText((String)token, (String)"token\u4e3a\u7a7a");
        CloudtOAuth2ClientProperties clientProperties = this.detectOAuth2ClientProperties(request);
        Assert.notNull((Object)clientProperties, (String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u5ba2\u6237\u7aef\u914d\u7f6e");
        EndpointInfo endpointInfo = this.endpointInfoMap.get(clientProperties.getClientId());
        if (endpointInfo == null) {
            endpointInfo = this.buildEndpointInfo(clientProperties);
        }
        LinkedMultiValueMap headers = new LinkedMultiValueMap(4);
        headers.add((Object)"Authorization", (Object)(tokenType + " " + token));
        try {
            ResponseEntity resp = this.restTemplate.exchange(endpointInfo.getUserinfoEndpoint(), HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<OAuth2UserInfoDTO>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                return (OAuth2UserInfoDTO)resp.getBody();
            }
            LOG.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0ctoken\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", (Object)(tokenType + " " + token), (Object)resp);
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff0ctoken:{}\uff0c\u5f02\u5e38\uff1a", (Object)(tokenType + " " + token), (Object)e);
        }
        return null;
    }

    @Override
    public OAuthToken clientToken() {
        CloudtOAuth2ClientProperties clientProperties = this.detectOAuth2ClientProperties(null);
        Assert.notNull((Object)clientProperties, (String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u5ba2\u6237\u7aef\u914d\u7f6e");
        EndpointInfo endpointInfo = this.endpointInfoMap.get(clientProperties.getClientId());
        if (endpointInfo == null) {
            endpointInfo = this.buildEndpointInfo(clientProperties);
        }
        LinkedMultiValueMap postParam = new LinkedMultiValueMap(8);
        postParam.add((Object)"grant_type", (Object)AuthorizationGrantType.CLIENT_CREDENTIALS.getValue());
        postParam.add((Object)"client_id", (Object)clientProperties.getClientId());
        postParam.add((Object)"client_secret", (Object)clientProperties.getClientSecret());
        try {
            ResponseEntity resp = this.restTemplate.exchange(endpointInfo.getTokenEndpoint(), HttpMethod.POST, new HttpEntity((Object)postParam), (ParameterizedTypeReference)new ParameterizedTypeReference<OAuthToken>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                return (OAuthToken)resp.getBody();
            }
            LOG.error("\u751f\u6210token\u5931\u8d25\uff1a{}", (Object)resp.getStatusCode());
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25\uff1a", (Throwable)e);
        }
        return null;
    }

    @Override
    public Boolean revokeToken(String token) {
        Assert.hasText((String)token, (String)"token\u4e3a\u7a7a");
        CloudtOAuth2ClientProperties clientProperties = this.detectOAuth2ClientProperties(null);
        Assert.notNull((Object)clientProperties, (String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u5ba2\u6237\u7aef\u914d\u7f6e");
        EndpointInfo endpointInfo = this.endpointInfoMap.get(clientProperties.getClientId());
        if (endpointInfo == null) {
            endpointInfo = this.buildEndpointInfo(clientProperties);
        }
        LinkedMultiValueMap postParam = new LinkedMultiValueMap(8);
        postParam.add((Object)"client_id", (Object)this.sdkProperties.getCasClient().getOauth2Client().getClientId());
        postParam.add((Object)"client_secret", (Object)this.sdkProperties.getCasClient().getOauth2Client().getClientSecret());
        postParam.add((Object)"token", (Object)token);
        try {
            ResponseEntity resp = this.restTemplate.exchange(endpointInfo.getRevocationEndpoint(), HttpMethod.POST, new HttpEntity((Object)postParam), (ParameterizedTypeReference)new ParameterizedTypeReference<String>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                return true;
            }
            LOG.error("\u6ce8\u9500token\u5931\u8d25\uff1a{}", (Object)resp.getStatusCode());
        }
        catch (Exception e) {
            LOG.error("\u6ce8\u9500token\u5931\u8d25\uff1a", (Throwable)e);
        }
        return false;
    }

    public void setUniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.uniqueRequestResolver = uniqueRequestResolver;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected CloudtOAuth2ClientProperties detectOAuth2ClientProperties(HttpServletRequest request) {
        return this.sdkProperties.getCasClient().getOauth2Client();
    }

    protected OAuthToken convertAuthToken(Map<String, Object> map) {
        try {
            return (OAuthToken)this.objectMapper.convertValue(map, OAuthToken.class);
        }
        catch (Exception e) {
            String originalValue = null;
            try {
                originalValue = this.objectMapper.writeValueAsString(map);
            }
            catch (JsonProcessingException ex) {
                LOG.info("json\u8f6c\u5b57\u7b26\u4e32\u5f02\u5e38\uff1a", (Throwable)ex);
            }
            LOG.error("\u8f6c\u6362token\u5931\u8d25\uff1a{}", (Object)originalValue, (Object)e);
            return null;
        }
    }

    protected String redirectUrlNameOfLogout() {
        return PARAM_REDIRECT_URL;
    }

    protected String detectServerAddr(HttpServletRequest request, CloudtOAuth2ClientProperties clientProperties, String defaultServerAddr) {
        if (request == null) {
            return defaultServerAddr;
        }
        String serverAddr = request.getParameter(PARAM_AUTH_SERVER);
        if (StringUtils.hasText((String)serverAddr)) {
            LOG.info("detect serverAddr from param\uff1a{}\uff0c{}", (Object)PARAM_AUTH_SERVER, (Object)serverAddr);
            return serverAddr;
        }
        String serverAddrHeaderName = clientProperties.getDetectServerAddrHeader();
        if (!StringUtils.hasText((String)serverAddrHeaderName)) {
            return defaultServerAddr;
        }
        String serverAddrHeader = request.getHeader(serverAddrHeaderName);
        if (!StringUtils.hasText((String)serverAddrHeader) || serverAddrHeader.startsWith(defaultServerAddr)) {
            return defaultServerAddr;
        }
        LOG.info("detect serverAddr from header\uff1a{}\uff0c{}", (Object)serverAddrHeaderName, (Object)serverAddrHeader);
        try {
            String path = URI.create(serverAddrHeader).getPath();
            String router = clientProperties.getDetectServerAddrRouter() == null ? "" : clientProperties.getDetectServerAddrRouter();
            return serverAddrHeader.substring(0, serverAddrHeader.indexOf(path)) + router;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u83b7\u53d6\u8ba4\u8bc1\u670d\u52a1\u5730\u5740\u5f02\u5e38\uff0c\u89e3\u6790\u8bf7\u6c42\u5934\u5931\u8d25\uff1a" + serverAddrHeader);
        }
    }

    private EndpointInfo buildEndpointInfo(CloudtOAuth2ClientProperties clientProperties) {
        String serverAddr = StringUtils.hasText((String)clientProperties.getServerAddr()) ? clientProperties.getServerAddr() : this.sdkProperties.getAuthServer();
        EndpointInfo endpointInfo = new EndpointInfo();
        endpointInfo.setServerAddr(serverAddr);
        if (!clientProperties.isDetectEndpoint()) {
            endpointInfo.setAuthorizeEndpoint(this.normalizeEndpoint(serverAddr, clientProperties.getAuthorizeEndpoint()));
            endpointInfo.setTokenEndpoint(this.normalizeEndpoint(serverAddr, clientProperties.getTokenEndpoint()));
            endpointInfo.setUserinfoEndpoint(this.normalizeEndpoint(serverAddr, clientProperties.getUserinfoEndpoint()));
            endpointInfo.setRevocationEndpoint(this.normalizeEndpoint(serverAddr, clientProperties.getRevocationEndpoint()));
            endpointInfo.setJwksUri(this.normalizeEndpoint(serverAddr, clientProperties.getJwksUri()));
            return endpointInfo;
        }
        String metadataUrl = this.normalizeEndpoint(serverAddr, clientProperties.getMetadataEndpoint());
        Map<String, Object> metadataInfo = this.restExchangeByGet(metadataUrl);
        if (CollectionUtils.isEmpty(metadataInfo)) {
            return null;
        }
        endpointInfo.setServerAddr((String)metadataInfo.get("issuer"));
        endpointInfo.setAuthorizeEndpoint((String)metadataInfo.get("authorization_endpoint"));
        endpointInfo.setTokenEndpoint((String)metadataInfo.get("token_endpoint"));
        endpointInfo.setUserinfoEndpoint((String)metadataInfo.get("userinfo_endpoint"));
        endpointInfo.setRevocationEndpoint((String)metadataInfo.get("revocation_endpoint"));
        endpointInfo.setJwksUri((String)metadataInfo.get("jwks_uri"));
        return endpointInfo;
    }

    private static HttpServletRequest currentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    private String buildLogoutUri(CloudtOAuth2ClientProperties clientProperties, String redirectUrl) {
        String logoutUri = clientProperties.getLogoutUri();
        if (!StringUtils.hasText((String)logoutUri)) {
            return null;
        }
        String redirectUrlName = this.redirectUrlNameOfLogout();
        if (StringUtils.hasText((String)redirectUrlName)) {
            int index = logoutUri.indexOf("?");
            if (index < 1) {
                return logoutUri + "?" + redirectUrlName + "=" + redirectUrl;
            }
            String paramsTemp = logoutUri.substring(index);
            return paramsTemp.contains(redirectUrlName) ? logoutUri : logoutUri + "&" + redirectUrlName + "=" + redirectUrl;
        }
        return logoutUri;
    }

    private String obtainRedirectUrl(HttpServletRequest request, CloudtOAuth2ClientProperties clientProperties) {
        String redirectUrl = request.getParameter(PARAM_REDIRECT_URL);
        if (StringUtils.hasText((String)redirectUrl)) {
            return redirectUrl;
        }
        return clientProperties.getRedirectUrl();
    }

    private void fillClientAuthentication(CloudtOAuth2ClientProperties clientProperties, HttpEntity entity) {
        clientProperties.getClientAuthenticationMethod();
    }

    private String normalizeEndpoint(String serverAddr, String endpoint) {
        if (!StringUtils.hasText((String)endpoint)) {
            return serverAddr;
        }
        if (((String)endpoint).toLowerCase().startsWith("http")) {
            return endpoint;
        }
        Assert.hasText((String)serverAddr, (String)"serverAddr\u4e3a\u7a7a");
        if (serverAddr.endsWith("/")) {
            serverAddr = serverAddr.substring(0, serverAddr.length() - 1);
        }
        if (!((String)endpoint).startsWith("/")) {
            endpoint = "/" + (String)endpoint;
        }
        return serverAddr + (String)endpoint;
    }

    private Map<String, Object> restExchangeByGet(String url) {
        try {
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                LOG.info("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u6210\u529f\uff1a{}", resp.getBody());
                return (Map)resp.getBody();
            }
            LOG.warn("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u5931\u8d25\uff1a{}", (Object)resp.getStatusCode());
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    static class AuthorizeCacheDefault
    implements AuthorizeCacheable {
        private final Cache<String, AuthorizeDTO> authorizeCache = Caffeine.newBuilder().maximumSize(2000L).expireAfterWrite(Duration.ofMinutes(60L)).build();

        @Override
        public void setCache(String reqId, AuthorizeDTO authorizeDTO) {
            this.authorizeCache.put((Object)reqId, (Object)authorizeDTO);
        }

        @Override
        public AuthorizeDTO get(String reqId) {
            return (AuthorizeDTO)this.authorizeCache.getIfPresent((Object)reqId);
        }
    }

    protected static class EndpointInfo {
        private String serverAddr;
        private String authorizeEndpoint;
        private String tokenEndpoint;
        private String userinfoEndpoint;
        private String revocationEndpoint;
        private String jwksUri;

        protected EndpointInfo() {
        }

        public String getServerAddr() {
            return this.serverAddr;
        }

        public void setServerAddr(String serverAddr) {
            this.serverAddr = serverAddr;
        }

        public String getAuthorizeEndpoint() {
            return this.authorizeEndpoint;
        }

        public void setAuthorizeEndpoint(String authorizeEndpoint) {
            this.authorizeEndpoint = authorizeEndpoint;
        }

        public String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        public String getUserinfoEndpoint() {
            return this.userinfoEndpoint;
        }

        public void setUserinfoEndpoint(String userinfoEndpoint) {
            this.userinfoEndpoint = userinfoEndpoint;
        }

        public String getRevocationEndpoint() {
            return this.revocationEndpoint;
        }

        public void setRevocationEndpoint(String revocationEndpoint) {
            this.revocationEndpoint = revocationEndpoint;
        }

        public String getJwksUri() {
            return this.jwksUri;
        }

        public void setJwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
        }
    }
}

