/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.task;

import com.elitescloud.boot.auth.cas.UserSourceProvider;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.cas.task.ClientTokenHolder;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.auth.util.AuthCompatibilityUtil;
import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class AutoSyncUserTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AutoSyncUserTask.class);
    private static final int MAX_SIZE = 100;
    private final UserSourceProvider userSourceProvider;
    private final UserTransferHelper transferHelper;
    private int syncSize = 50;
    private boolean rollbackAllOnException;

    public AutoSyncUserTask(String authServer, UserSourceProvider userSourceProvider) {
        this.userSourceProvider = userSourceProvider;
        this.transferHelper = UserTransferHelper.getInstance(authServer);
    }

    @Override
    public void run() {
        if (this.userSourceProvider == null) {
            return;
        }
        if (this.syncSize < 1) {
            return;
        }
        int size = Math.min(this.syncSize, 100);
        for (int times = 0; times < 3; ++times) {
            if (!ClientTokenHolder.hasToken()) {
                LOG.info("OAuth2\u5ba2\u6237\u7aef\u672a\u521d\u59cb\u5316\u6210\u529f\uff1a{}", (Object)(times + 1));
                try {
                    TimeUnit.MINUTES.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.startSync(size);
            break;
        }
    }

    private void startSync(int size) {
        List<com.elitescloud.boot.auth.cas.model.AuthUserDTO> users = this.queryUserList(size);
        while (!CollectionUtils.isEmpty(users)) {
            Result<HashMap<String, Long>> result = this.transferHelper.upsertUserBatch(this.rollbackAllOnException, users);
            if (!result.getSuccess().booleanValue()) {
                LOG.error("CAS\u540c\u6b65\u7528\u6237\u8d26\u53f7\u5931\u8d25\uff1a{}", (Object)result.getMsg());
                break;
            }
            if (!CollectionUtils.isEmpty((Map)result.getData())) {
                this.userSourceProvider.successCallback((Map<String, Long>)result.getData());
            }
            users = this.queryUserList(size);
        }
    }

    public void setSyncSize(int syncSize) {
        Assert.isTrue((syncSize < 100 ? 1 : 0) != 0, (String)"\u6700\u5927\u503c\u4e3a100");
        this.syncSize = syncSize;
    }

    public void setRollbackAllOnException(boolean rollbackAllOnException) {
        this.rollbackAllOnException = rollbackAllOnException;
    }

    private List<com.elitescloud.boot.auth.cas.model.AuthUserDTO> queryUserList(int size) {
        if (this.userSourceProvider instanceof com.elitescloud.cloudt.authorization.sdk.cas.UserSourceProvider) {
            List<AuthUserDTO> users = ((com.elitescloud.cloudt.authorization.sdk.cas.UserSourceProvider)this.userSourceProvider).queryUser(size);
            return AuthCompatibilityUtil.convert(users);
        }
        return this.userSourceProvider.queryUserList(size);
    }
}

