package com.elitescloud.boot.auth.cas.model.login;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;

/**
 * 登录日志查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/6
 */
public class AuthLoginLogQueryDTO implements Serializable {
    private static final long serialVersionUID = -4985369215122775872L;

    /**
     * 页码，默认0
     * <p>
     * 取值范围：0 ~
     */
    private Integer page;

    /**
     * 页码大小，默认10
     * <p>
     * 取值范围：1 ~ 50
     */
    private Integer pageSize;

    /**
     * 用户ID
     */
    private Set<Long> userIds;

    /**
     * 登录号
     */
    private Set<String> usernames;

    /**
     * 登录成功与否
     */
    private Boolean success;

    /**
     * 登录时间：起始时间
     */
    private LocalDateTime loginTimeStart;

    /**
     * 登录时间：截止时间
     */
    private LocalDateTime loginTimeEnd;

    /**
     * 只显示最后一次登录
     *
     * <li>true：只显示最后一次登录时间；</li>
     * <li>false：只显示第一次登录时间；</li>
     * <li>null：显示所有</li>
     */
    private Boolean onlyLastLogin;

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Set<Long> getUserIds() {
        return userIds;
    }

    public void setUserIds(Set<Long> userIds) {
        this.userIds = userIds;
    }

    public Set<String> getUsernames() {
        return usernames;
    }

    public void setUsernames(Set<String> usernames) {
        this.usernames = usernames;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public LocalDateTime getLoginTimeStart() {
        return loginTimeStart;
    }

    public void setLoginTimeStart(LocalDateTime loginTimeStart) {
        this.loginTimeStart = loginTimeStart;
    }

    public LocalDateTime getLoginTimeEnd() {
        return loginTimeEnd;
    }

    public void setLoginTimeEnd(LocalDateTime loginTimeEnd) {
        this.loginTimeEnd = loginTimeEnd;
    }

    public Boolean getOnlyLastLogin() {
        return onlyLastLogin;
    }

    public void setOnlyLastLogin(Boolean onlyLastLogin) {
        this.onlyLastLogin = onlyLastLogin;
    }
}
