package com.elitescloud.boot.auth.config;

import org.springframework.security.oauth2.core.AuthenticationMethod;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * OAuth2客户端属性.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/18
 */
public class CloudtOAuth2ClientProperties implements Serializable {
    private static final long serialVersionUID = -6618233338422165029L;

    /**
     * 服务端地址
     */
    private String serverAddr;
    /**
     * 客户端ID
     */
    @NotBlank
    private String clientId;
    /**
     * 客户端secret
     */
    @NotBlank
    private String clientSecret;
    /**
     * 客户端名称
     */
    private String clientName;
    /**
     * 登录成功后的重定向url
     */
    private String redirectUrl;
    /**
     * 客户端认证方式
     * <p>
     * {@link ClientAuthenticationMethod}
     */
    private String clientAuthenticationMethod = ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue();
    /**
     * 是否启用PKCE
     */
    private boolean pkceEnabled = true;
    /**
     * 自动发现服务端地址的请求头
     */
    private String detectServerAddrHeader;

    /**
     * 路由地址
     */
    private String detectServerAddrRouter = "/cloudt/authorization";
    /**
     * 自动发现认证地址
     */
    private boolean detectEndpoint = false;
    /**
     * endpoint元数据地址
     */
    private String metadataEndpoint = "/.well-known/openid-configuration";
    /**
     * 服务端认证地址
     */
    private String authorizeEndpoint = "/oauth2/authorize";
    /**
     * 服务端生成token地址
     */
    private String tokenEndpoint = "/oauth2/token";
    /**
     * 撤销token
     */
    private String revocationEndpoint = "/oauth2/revoke";
    /**
     * jwks地址
     */
    private String jwksUri = "/oauth2/jwks";
    /**
     * 用户信息地址
     */
    private String userinfoEndpoint = "/userinfo";

    /**
     * 用户信息认证方式
     * <p>
     * {@link AuthenticationMethod}
     */
    private String userInfoAuthenticationMethod = AuthenticationMethod.HEADER.getValue();

    /**
     * 注销URL
     */
    private String logoutUri = "/oauth/login/logout";

    public String getServerAddr() {
        return serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientName() {
        return clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public String getClientAuthenticationMethod() {
        return clientAuthenticationMethod;
    }

    public void setClientAuthenticationMethod(String clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }

    public boolean isPkceEnabled() {
        return pkceEnabled;
    }

    public void setPkceEnabled(boolean pkceEnabled) {
        this.pkceEnabled = pkceEnabled;
    }

    public String getDetectServerAddrHeader() {
        return detectServerAddrHeader;
    }

    public void setDetectServerAddrHeader(String detectServerAddrHeader) {
        this.detectServerAddrHeader = detectServerAddrHeader;
    }

    public String getDetectServerAddrRouter() {
        return detectServerAddrRouter;
    }

    public void setDetectServerAddrRouter(String detectServerAddrRouter) {
        this.detectServerAddrRouter = detectServerAddrRouter;
    }

    public boolean isDetectEndpoint() {
        return detectEndpoint;
    }

    public void setDetectEndpoint(boolean detectEndpoint) {
        this.detectEndpoint = detectEndpoint;
    }

    public String getMetadataEndpoint() {
        return metadataEndpoint;
    }

    public void setMetadataEndpoint(String metadataEndpoint) {
        this.metadataEndpoint = metadataEndpoint;
    }

    public String getAuthorizeEndpoint() {
        return authorizeEndpoint;
    }

    public void setAuthorizeEndpoint(String authorizeEndpoint) {
        this.authorizeEndpoint = authorizeEndpoint;
    }

    public String getTokenEndpoint() {
        return tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getRevocationEndpoint() {
        return revocationEndpoint;
    }

    public void setRevocationEndpoint(String revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
    }

    public String getJwksUri() {
        return jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getUserinfoEndpoint() {
        return userinfoEndpoint;
    }

    public void setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }

    public String getUserInfoAuthenticationMethod() {
        return userInfoAuthenticationMethod;
    }

    public void setUserInfoAuthenticationMethod(String userInfoAuthenticationMethod) {
        this.userInfoAuthenticationMethod = userInfoAuthenticationMethod;
    }

    public String getLogoutUri() {
        return logoutUri;
    }

    public void setLogoutUri(String logoutUri) {
        this.logoutUri = logoutUri;
    }
}
