package com.elitescloud.boot.auth.cas;

import com.elitescloud.boot.auth.cas.model.AuthorizeDTO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 认证缓存接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/11
 */
public interface AuthorizeCacheable {

    /**
     * 设置缓存
     *
     * @param reqId        reqId
     * @param authorizeDTO 认证信息
     */
    void setCache(@NotBlank String reqId, @NotNull AuthorizeDTO authorizeDTO);

    /**
     * 获取认证信息
     *
     * @param reqId reqId
     * @return 认证信息
     */
    AuthorizeDTO get(@NotBlank String reqId);
}
