package com.elitescloud.boot.auth.cas.model;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;

/**
 * 登录用户详细信息的扩展信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/30
 */
public class UserDetailExtendDTO implements Serializable {
    private static final long serialVersionUID = 5057838512562079309L;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户密码
     */
    private transient String password;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 账号是否锁定
     */
    private Boolean locked;

    /**
     * 锁定截止时间
     */
    private LocalDateTime lockEndTime;

    /**
     * 密码是否需要重置
     */
    private Boolean needReset;

    /**
     * 密码过期时间
     */
    private LocalDateTime pwdExpiredTime;

    /**
     * 账号过期时间
     */
    private LocalDateTime expiredTime;

    /**
     * 是否限制只能在线一个
     */
    private Boolean onlineLimitOne;

    /**
     * 客户端token有效期
     */
    private Duration tokenTtl;

    /**
     * token是否支持刷新
     */
    private Boolean tokenRenewal;

    /**
     * 刷新token有效期
     */
    private Duration refreshTokenTtl;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getLocked() {
        return locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public LocalDateTime getLockEndTime() {
        return lockEndTime;
    }

    public void setLockEndTime(LocalDateTime lockEndTime) {
        this.lockEndTime = lockEndTime;
    }

    public Boolean getNeedReset() {
        return needReset;
    }

    public void setNeedReset(Boolean needReset) {
        this.needReset = needReset;
    }

    public LocalDateTime getPwdExpiredTime() {
        return pwdExpiredTime;
    }

    public void setPwdExpiredTime(LocalDateTime pwdExpiredTime) {
        this.pwdExpiredTime = pwdExpiredTime;
    }

    public LocalDateTime getExpiredTime() {
        return expiredTime;
    }

    public void setExpiredTime(LocalDateTime expiredTime) {
        this.expiredTime = expiredTime;
    }

    public Boolean getOnlineLimitOne() {
        return onlineLimitOne;
    }

    public void setOnlineLimitOne(Boolean onlineLimitOne) {
        this.onlineLimitOne = onlineLimitOne;
    }

    public Duration getTokenTtl() {
        return tokenTtl;
    }

    public void setTokenTtl(Duration tokenTtl) {
        this.tokenTtl = tokenTtl;
    }

    public Boolean getTokenRenewal() {
        return tokenRenewal;
    }

    public void setTokenRenewal(Boolean tokenRenewal) {
        this.tokenRenewal = tokenRenewal;
    }

    public Duration getRefreshTokenTtl() {
        return refreshTokenTtl;
    }

    public void setRefreshTokenTtl(Duration refreshTokenTtl) {
        this.refreshTokenTtl = refreshTokenTtl;
    }
}
