package com.elitescloud.boot.auth.cas.provider;

import com.elitescloud.boot.auth.cas.model.login.AuthLoginLogDTO;
import com.elitescloud.boot.auth.cas.model.login.AuthLoginLogQueryDTO;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 登录日志传输服务.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/16
 */
public class LoginLogTransferHelper extends BaseTransferHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LoginLogTransferHelper.class);

    private static LoginLogTransferHelper transferHelper = null;

    protected LoginLogTransferHelper(String authServer) {
        super(authServer);
    }

    /**
     * 创建工具实例
     *
     * @param authServer 认证服务器地址
     * @return 工具实例
     */
    public static LoginLogTransferHelper getInstance(@NotBlank String authServer) {
        synchronized (LoginLogTransferHelper.class) {
            if (transferHelper == null) {
                transferHelper = new LoginLogTransferHelper(authServer);
            }
        }
        return transferHelper;
    }

    /**
     * 查询登录日志
     *
     * @param queryDTO 查询信息
     * @return 日志列表
     */
    public Result<PagingVO<AuthLoginLogDTO>> queryPage(@NotNull AuthLoginLogQueryDTO queryDTO) {
        Assert.notNull(queryDTO, "查询参数为空");

        return remoteExchange(CasUrlConstant.URI_LOGIN_LOG_PAGE, HttpMethod.POST, new HttpEntity<>(queryDTO),
                new TypeReference<>() {
                });
    }
}
