package com.elitescloud.boot.auth.resolver;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 唯一请求处理器.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/26
 */
public interface UniqueRequestResolver {

    /**
     * 标记请求
     *
     * @return 唯一标记
     */
    String signRequest(HttpServletResponse response);

    /**
     * 分析请求
     *
     * @param request request
     * @return 请求标识
     */
    String analyze(HttpServletRequest request);

    /**
     * 清除标记
     *
     * @param response response
     * @param reqId    请求标识
     */
    void clear(HttpServletResponse response, String reqId);
}
