/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Random;
import javax.validation.constraints.NotBlank;

public final class AuthSdkUtil {
    private static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    private static final MessageDigest digestSha256;

    private AuthSdkUtil() {
    }

    public static String generateCodeVerifier() {
        int len = BASE_CHAR.length();
        Random random = new Random();
        StringBuilder stateBuilder = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            stateBuilder.append(BASE_CHAR.charAt(random.nextInt(len)));
        }
        return stateBuilder.toString();
    }

    public static String generateCodeChallenge(@NotBlank String codeVerifier) {
        byte[] bytes = digestSha256.digest(codeVerifier.getBytes(StandardCharsets.US_ASCII));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    static {
        try {
            digestSha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

