/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.data.support.id.provider.uidgenerator.worker;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import com.elitescloud.boot.data.support.id.config.GenType;
import com.elitescloud.boot.data.support.id.config.IdProperties;
import com.elitescloud.boot.data.support.id.provider.uidgenerator.worker.AbstractWorkerIdAssigner;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class DatabaseWorkerIdAssigner
extends AbstractWorkerIdAssigner {
    private static final Logger log = LogManager.getLogger(DatabaseWorkerIdAssigner.class);
    private static final String SQL_INSERT = "insert into sys_id_generator(id, gen_type, data_center_name, data_center_id, worker_id, instance_ip, create_time, modify_time) value (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_QUERY_WORKER_ID = "select worker_id from sys_id_generator ";
    private static final String SQL_REFRESH = "update sys_id_generator set modify_time = ? where data_center_id = ? and worker_id = ?";
    private static final String SQL_DELETE_EXPIRE = "delete from sys_id_generator where modify_time < ?";
    private static final String SQL_DESTROY = "delete from sys_id_generator where data_center_id = ? and worker_id = ?";
    private static final int RETRY_FACTORY = 100;
    private static final int DATA_CENTER_ID = -1;
    private final IdProperties idProperties;
    private final JdbcTemplate jdbcTemplate;
    private final String dataCenterName;
    private long workerId;

    public DatabaseWorkerIdAssigner(IdProperties idProperties, JdbcTemplate jdbcTemplate, String dataCenterName) {
        this.idProperties = idProperties;
        this.jdbcTemplate = jdbcTemplate;
        this.dataCenterName = dataCenterName;
    }

    @Override
    public void refreshAlive() {
        LocalDateTime now = LocalDateTime.now();
        try {
            this.jdbcTemplate.update(SQL_REFRESH, new Object[]{now, -1, this.workerId});
            this.jdbcTemplate.update(SQL_DELETE_EXPIRE, new Object[]{now.minusMinutes(this.idProperties.getAlive().toMinutes())});
        }
        catch (DataAccessException e) {
            log.error("\u5237\u65b0UID workerIdAssigner\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        try {
            this.jdbcTemplate.update(SQL_DESTROY, new Object[]{-1, this.workerId});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long assignWorkerId() {
        long id;
        this.workerId = id = this.generateWorkerId();
        return id;
    }

    private long generateWorkerId() {
        long max = super.maxWorkerId(this.idProperties);
        List existsWorkerIds = this.jdbcTemplate.queryForList(SQL_QUERY_WORKER_ID, Long.class);
        int retryTimes = 0;
        String ip = super.getIp();
        while (true) {
            long temp;
            if (existsWorkerIds.contains(temp = RandomUtil.randomLong((long)max))) {
                continue;
            }
            LocalDateTime now = LocalDateTime.now();
            try {
                this.jdbcTemplate.update(SQL_INSERT, new Object[]{IdUtil.fastSimpleUUID(), GenType.UID_GENERATOR.name(), this.dataCenterName, -1, temp, ip, now, now});
                return temp;
            }
            catch (DataAccessException e) {
                if (++retryTimes < 100) continue;
                log.warn("\u5c1d\u8bd5\u4f7f\u7528WorkerId\u7b2c{}\u6b21", (Object)retryTimes);
                continue;
            }
            break;
        }
    }
}

