/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.data.support.id.provider.uidgenerator.config;

import com.elitescloud.boot.data.support.id.config.IdProperties;
import com.elitescloud.boot.data.support.id.provider.uidgenerator.UidGenerator;
import com.elitescloud.boot.data.support.id.provider.uidgenerator.UidProvider;
import com.elitescloud.boot.data.support.id.provider.uidgenerator.config.UidProperties;
import com.elitescloud.boot.data.support.id.provider.uidgenerator.impl.CachedUidGenerator;
import com.elitescloud.boot.data.support.id.provider.uidgenerator.worker.DatabaseWorkerIdAssigner;
import com.elitescloud.boot.data.support.id.provider.uidgenerator.worker.ManualWorkerIdAssigner;
import com.elitescloud.boot.data.support.id.provider.uidgenerator.worker.RedisWorkerIdAssigner;
import com.elitescloud.boot.data.support.id.provider.uidgenerator.worker.WorkerIdAssigner;
import com.elitescloud.boot.data.support.id.util.IdTool;
import com.elitescloud.cloudt.context.util.DatetimeUtil;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.JdbcProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

@ConditionalOnProperty(prefix="elitesland.id", name={"gen-type"}, havingValue="UID_GENERATOR")
@Import(value={RedisSupportConfig.class})
public class UidConfig
implements EnvironmentAware,
InitializingBean {
    private static final Logger log = LogManager.getLogger(UidConfig.class);
    @Value(value="${spring.application.name:#{'unknown'}}")
    private String dataCenterName;
    private final IdProperties idProperties;
    private final DataSource dataSource;
    private Environment environment;

    public UidConfig(IdProperties idProperties, DataSource dataSource) {
        this.idProperties = idProperties;
        this.dataSource = dataSource;
    }

    public void setEnvironment(@NonNull Environment environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() throws Exception {
        this.logGeneratorInfo();
    }

    @Bean
    public UidProvider uidProvider(UidGenerator uidGenerator, WorkerIdAssigner workerIdAssigner) {
        return new UidProvider(uidGenerator, workerIdAssigner);
    }

    @Bean
    public CachedUidGenerator cachedUidGenerator(WorkerIdAssigner workerIdAssigner) {
        CachedUidGenerator cachedUidGenerator = new CachedUidGenerator();
        UidProperties properties = this.idProperties.getUid();
        int total = properties.getTimeBits() + properties.getWorkerBits() + properties.getSeqBits();
        Assert.isTrue((total == 63 ? 1 : 0) != 0, (String)"uid\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff0ctimeBits + workerBits + seqBits = 64");
        cachedUidGenerator.setTimeBits(properties.getTimeBits());
        cachedUidGenerator.setWorkerBits(properties.getWorkerBits());
        cachedUidGenerator.setSeqBits(properties.getSeqBits());
        cachedUidGenerator.setBoostPower(properties.getBoostPower());
        cachedUidGenerator.setPaddingFactor(properties.getPaddingFactor());
        cachedUidGenerator.setEpochStr(properties.getEpochStr());
        cachedUidGenerator.setWorkerIdAssigner(workerIdAssigner);
        return cachedUidGenerator;
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.id", name={"assigner-type"}, havingValue="MANUAL", matchIfMissing=true)
    public WorkerIdAssigner workerIdAssignerManual() {
        return new ManualWorkerIdAssigner(this.idProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.id", name={"assigner-type"}, havingValue="DATABASE")
    public WorkerIdAssigner workerIdAssignerDatabase(JdbcProperties properties) {
        JdbcTemplate jdbcTemplate = IdTool.buildJdbcTemplate(this.environment, this.dataSource, this.idProperties, properties);
        return new DatabaseWorkerIdAssigner(this.idProperties, jdbcTemplate, this.dataCenterName);
    }

    private void logGeneratorInfo() {
        DateTimeFormatter formatter = DatetimeUtil.FORMATTER_DATE;
        UidProperties prop = this.idProperties.getUid();
        LocalDateTime epochStart = LocalDateTime.of(LocalDate.parse(prop.getEpochStr(), formatter), LocalTime.MIN);
        LocalDateTime epochEnd = epochStart.plus(Duration.ofSeconds(1L << prop.getTimeBits()));
        long years = Duration.between(epochStart, epochEnd).toDays() / 365L;
        long qps = 1L << prop.getSeqBits();
        long workers = 1L << prop.getWorkerBits();
        log.info("ID\u751f\u6210\u5668\u3010uid-generator\u3011\u51c6\u5907\u4e2d\uff0c\u53ef\u4f7f\u7528\u5e74\u9650{}\u5e74\uff0c\u4ece{}\u81f3{}\uff0c\u5e76\u53d1\u91cf\u652f\u6301{}\u4e07\u6bcf\u79d2\uff0c\u652f\u6301\u7684\u670d\u52a1\u6570\u91cf{}\u4e07", (Object)years, (Object)epochStart.format(formatter), (Object)epochEnd.format(formatter), (Object)((double)(qps <<= prop.getBoostPower()) / 10000.0), (Object)((double)workers / 10000.0));
    }

    @Configuration
    @ConditionalOnClass(value={RedisTemplate.class})
    static class RedisSupportConfig {
        @Value(value="${spring.application.name:#{'unknown'}}")
        private String dataCenterName;
        private final IdProperties idProperties;

        public RedisSupportConfig(IdProperties idProperties) {
            this.idProperties = idProperties;
        }

        @Bean
        @ConditionalOnProperty(prefix="elitesland.id", name={"assigner-type"}, havingValue="REDIS")
        public WorkerIdAssigner workerIdAssignerRedis(RedisTemplate redisTemplate) {
            return new RedisWorkerIdAssigner(this.idProperties, redisTemplate, this.dataCenterName);
        }
    }
}

