/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.data.support.id.provider.uidgenerator.worker;

import cn.hutool.core.util.RandomUtil;
import com.elitescloud.boot.data.support.id.config.IdProperties;
import com.elitescloud.boot.data.support.id.provider.uidgenerator.worker.AbstractWorkerIdAssigner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

public class RedisWorkerIdAssigner
extends AbstractWorkerIdAssigner {
    private static final Logger log = LogManager.getLogger(RedisWorkerIdAssigner.class);
    private static String CACHE_KEY = "cloudt_uid";
    private static final int RETRY_FACTORY = 100;
    private final IdProperties idProperties;
    private final RedisTemplate redisTemplate;
    private final String dataCenterName;
    private long workerId;

    public RedisWorkerIdAssigner(IdProperties idProperties, RedisTemplate redisTemplate, String dataCenterName) {
        this.idProperties = idProperties;
        this.redisTemplate = redisTemplate;
        this.dataCenterName = dataCenterName;
        if (StringUtils.hasText((String)idProperties.getUid().getCachePrefix())) {
            CACHE_KEY = idProperties.getUid().getCachePrefix();
        }
    }

    @Override
    public void refreshAlive() {
        this.redisTemplate.opsForValue().set((Object)this.cacheKeyWorkerId(this.workerId), (Object)this.name(), this.idProperties.getAlive());
    }

    @Override
    public void destroy() {
        String key = this.cacheKeyWorkerId(this.workerId);
        try {
            this.redisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            log.error("\u9500\u6bc1UID\u7684workerId\u5b9e\u4f8b\u5f02\u5e38\uff1a", (Throwable)e);
        }
        log.info("UID\u7684workerId\u5b9e\u4f8b\u9500\u6bc1\uff1a{}", (Object)key);
    }

    @Override
    public long assignWorkerId() {
        long id;
        this.workerId = id = this.generateWorkerId();
        return id;
    }

    private long generateWorkerId() {
        long max = super.maxWorkerId(this.idProperties);
        String value = this.name();
        int retryTimes = 0;
        while (true) {
            long temp = RandomUtil.randomLong((long)max);
            boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)this.cacheKeyWorkerId(temp), (Object)value, this.idProperties.getAlive());
            if (result) {
                return temp;
            }
            if (++retryTimes < 100) continue;
            log.warn("\u5c1d\u8bd5\u4f7f\u7528WorkerId\u7b2c{}\u6b21", (Object)retryTimes);
        }
    }

    private String cacheKeyWorkerId(Long theWorkerId) {
        return CACHE_KEY + ":worker_" + theWorkerId;
    }

    private String name() {
        return this.dataCenterName + "::" + super.getIp();
    }
}

