/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.data.support.id.provider.custom;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.provider.CloudtIdCreator;
import org.slf4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;

@ConditionalOnProperty(prefix="elitesland.id", name={"gen-type"}, havingValue="CUSTOM")
@Import(value={CustomIdProviderSelector.class})
public class CustomIdGenConfig {
    private static final Logger logger = CloudtBootLoggerFactory.REPO.getLogger(CustomIdGenConfig.class);

    static class CustomIdProviderSelector
    implements DeferredImportSelector,
    EnvironmentAware {
        private Environment environment;

        CustomIdProviderSelector() {
        }

        public void setEnvironment(@NonNull Environment environment) {
            this.environment = environment;
        }

        @NonNull
        public String[] selectImports(@NonNull AnnotationMetadata importingClassMetadata) {
            String generator = this.environment.getProperty("elitesland.id.custom-generator");
            if (CharSequenceUtil.isBlank((CharSequence)generator)) {
                generator = "com.elitescloud.boot.core.yst.impl.YstSystemIdProvider";
            }
            Class<?> clazzGenerator = null;
            try {
                clazzGenerator = Class.forName(generator);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("\u81ea\u5b9a\u4e49ID\u751f\u6210\u5668\u4e0d\u5b58\u5728\uff1a" + generator, e);
            }
            Assert.isTrue((boolean)CloudtIdCreator.class.isAssignableFrom(clazzGenerator), (String)"\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u81ea\u5b9a\u4e49ID\u751f\u6210\u5668\u7c7b\uff01", (Object[])new Object[0]);
            return new String[]{generator};
        }
    }
}

