/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.dpr.service.util;

import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.service.util.DataPermissionRuleServiceUtil;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleDatePermissionColumnUtil {
    private static final Logger log = LoggerFactory.getLogger(RoleDatePermissionColumnUtil.class);
    public static final String[] GROUP_STR = new String[]{"DPRaa", "DPRbb", "DPRcc", "DPRdd", "DPRee", "DPRff", "DPRgg", "DPRhh", "DPRii", "DPRjj", "DPRkk", "DPRll", "DPRmm", "DPRnn", "DPRoo", "DPRpp", "DPRqq", "DPRrr", "DPRss", "DPRtt", "DPRuu", "DPRvv", "DPRww", "DPRxx", "DPRyy", "DPRzz"};
    public static final String SB_MAP_GROUP_EXPR = MapBuilder.GROUP_EXPR;
    public static final String TENANT_ID_GROUP = "tenantIdGroup";

    public static void setColumnMapBuilder(Field[] fields, List<SysDpcRoleApiFieldsDTO> columnDto, MapBuilder mapBuilder) {
        StringBuilder columnOnlStr = new StringBuilder();
        StringBuilder columnExcludeStr = new StringBuilder();
        List uniqueFields = Arrays.stream(fields).collect(Collectors.collectingAndThen(Collectors.toMap(Field::getName, field -> field, (existing, replacement) -> existing), map -> new ArrayList(map.values())));
        for (Field field2 : uniqueFields) {
            Boolean isApiFiledRule = false;
            for (SysDpcRoleApiFieldsDTO dto : columnDto) {
                if (!field2.getName().equals(dto.getFieldName())) continue;
                if (dto.getFieldApiVisible().booleanValue()) {
                    if (columnOnlStr.length() == 0) {
                        columnOnlStr.append(dto.getFieldName());
                    } else {
                        columnOnlStr.append(",").append(dto.getFieldName());
                    }
                } else if (columnExcludeStr.length() == 0) {
                    columnExcludeStr.append(dto.getFieldName());
                } else {
                    columnExcludeStr.append(",").append(dto.getFieldName());
                }
                isApiFiledRule = true;
                break;
            }
            if (isApiFiledRule.booleanValue()) continue;
            if (columnOnlStr.length() == 0) {
                columnOnlStr.append(field2.getName());
                continue;
            }
            columnOnlStr.append(",").append(field2.getName());
        }
        if (columnOnlStr.length() != 0) {
            mapBuilder.onlySelect(new String[]{columnOnlStr.toString()});
        }
        if (columnExcludeStr.length() != 0) {
            mapBuilder.selectExclude(new String[]{columnExcludeStr.toString()});
        }
    }

    public static String tenantAuthBuilder(TenantClientProvider tenantClientProvider, MapBuilder mapBuilder, Map<String, Object> params) {
        GeneralUserDetails userInfo = SecurityContextUtil.currentUser();
        Long tenantId = -1L;
        if (tenantClientProvider.enabledTenant()) {
            if (userInfo != null && userInfo.getTenantId() != null) {
                tenantId = userInfo.getTenantId();
            } else {
                SysTenantDTO tenant = tenantClientProvider.getSessionTenant();
                if (tenant != null) {
                    tenantId = tenant.getId();
                }
            }
        }
        mapBuilder.group(TENANT_ID_GROUP);
        ((MapBuilder)mapBuilder.field(BaseModel::getTenantId, new Object[]{tenantId})).op((FieldOp)FieldOps.Equal);
        String bsGroupExpr = RoleDatePermissionColumnUtil.getBeanSearcherGroupExpr(params);
        StringBuffer groupExpr = new StringBuffer();
        if (bsGroupExpr != null && bsGroupExpr.length() > 0) {
            groupExpr.append(bsGroupExpr).append("&tenantIdGroup");
        } else {
            groupExpr.append(TENANT_ID_GROUP);
        }
        return groupExpr.toString();
    }

    public static String tenantBuilder(TenantClientProvider tenantClientProvider, MapBuilder mapBuilder, Map<String, Object> params) {
        GeneralUserDetails userInfo = SecurityContextUtil.currentUser();
        Long tenantId = -1L;
        if (tenantClientProvider.enabledTenant()) {
            if (userInfo != null && userInfo.getTenantId() != null) {
                tenantId = userInfo.getTenantId();
            } else {
                SysTenantDTO tenant = tenantClientProvider.getSessionTenant();
                if (tenant != null) {
                    tenantId = tenant.getId();
                }
            }
        }
        String bsGroupExpr = RoleDatePermissionColumnUtil.getBeanSearcherGroupExpr(params);
        StringBuffer groupExpr = new StringBuffer();
        if (bsGroupExpr != null && bsGroupExpr.length() > 0) {
            mapBuilder.group(TENANT_ID_GROUP);
            ((MapBuilder)mapBuilder.field(BaseModel::getTenantId, new Object[]{tenantId})).op((FieldOp)FieldOps.Equal);
            groupExpr.append(bsGroupExpr).append("&tenantIdGroup");
        } else {
            ((MapBuilder)mapBuilder.field(BaseModel::getTenantId, new Object[]{tenantId})).op((FieldOp)FieldOps.Equal);
            groupExpr.append(TENANT_ID_GROUP);
        }
        return groupExpr.toString();
    }

    public static String getBeanSearcherGroupExpr(Map<String, Object> params) {
        return params.get(SB_MAP_GROUP_EXPR) != null ? params.get(SB_MAP_GROUP_EXPR).toString() : null;
    }

    public static void addSetBeanSearcherGroupExpr(Map<String, Object> params, String groupExpr) {
        Object drpGroupExpr = params.get(SB_MAP_GROUP_EXPR);
        params.put(SB_MAP_GROUP_EXPR, String.valueOf(drpGroupExpr) + groupExpr);
    }

    public static void jointGroupExpr(int i, int size, SysDprRoleApiDataRuleListQueryDTO rule, String gStr, StringBuilder groupExpr) {
        if (size == 0) {
            return;
        }
        if (i == 0) {
            groupExpr.append("(").append(gStr);
            if (size == 1) {
                groupExpr.append(")");
            }
        } else if (i == size - 1) {
            if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_OR.name())) {
                groupExpr.append("|").append(gStr).append(")");
            } else if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name())) {
                groupExpr.append("&").append(gStr).append(")");
            } else {
                DataPermissionRuleServiceUtil.throwRuntimeException("\u975e\u6cd5\u7684DprRuleRelation \u89c4\u5219\u5173\u7cfb\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u7ba1\u7406\u5458\u3002\uff1a", rule);
            }
        } else if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_OR.name())) {
            groupExpr.append("|").append(gStr);
        } else if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name())) {
            groupExpr.append("&").append(gStr);
        } else {
            DataPermissionRuleServiceUtil.throwRuntimeException("\u975e\u6cd5\u7684DprRuleRelation \u89c4\u5219\u5173\u7cfb\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u7ba1\u7406\u5458\u3002\uff1a", rule);
        }
    }
}

