/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.datasecurity.common.extension.FieldPermissionExtension;
import com.elitescloud.boot.datasecurity.config.DataSecurityProperties;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.jpa.strategy.RuleStrategyManager;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.system.dto.BaseDataSecurityRuleDTO;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.dromara.dynamictp.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DataSecurityUtil {
    private static final Logger log = LoggerFactory.getLogger(DataSecurityUtil.class);
    private static RoleDataPermissionRuleService roleDataPermissionRuleService;
    private static DataSecurityProperties dataSecurityProperties;
    private static List<FieldPermissionExtension> fieldPermissionExtensions;
    private static final InheritableThreadLocal<BusinessContext> BUSINESS_CONTEXT;

    private DataSecurityUtil() {
    }

    public static Predicate predicateForJPA(@NotNull Class<?> entityClass) {
        return DataSecurityUtil.predicateForJPA(entityClass, null, new String[0]);
    }

    public static Predicate predicateForJPA(@NotNull Class<?> entityClass, String alias, String ... ruleFieldName) {
        Assert.notNull(entityClass, (String)"\u5b9e\u4f53\u7c7b\u4e3a\u7a7a");
        if (CharSequenceUtil.isBlank((CharSequence)alias)) {
            String entityName = entityClass.getSimpleName();
            alias = entityName.substring(0, 1).toLowerCase() + entityName.substring(1);
        }
        try {
            SysDprRoleApiRowColumnRuleDTO userRoleDpr = DataSecurityUtil.queryDataPermission();
            return DataSecurityUtil.getAuthJpaPredicate(userRoleDpr, entityClass, (String)alias, ruleFieldName);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u6743\u9650\u6761\u4ef6\u751f\u6210\u5f02\u5e38\uff1a{}", (Object)entityClass.getName(), (Object)e);
            return new BooleanBuilder(null);
        }
    }

    public static void eraseByFieldPermission(Object data) {
        if (ObjUtil.isEmpty((Object)data)) {
            return;
        }
        Set<String> fieldNames = DataSecurityUtil.getUnreadableFields();
        if (fieldNames.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        ObjUtil.unwrap((Object)data, d -> {
            HashSet<String> eraseFieldNames = new HashSet<String>(fieldNames);
            eraseFieldNames.addAll(DataSecurityUtil.getUnreadableFieldsByExtension(d, Collections.unmodifiableSet(fieldNames)));
            DataSecurityUtil.eraseObjectValue(d, eraseFieldNames, DataSecurityUtil.getDataSecurityProperties().getFieldPermission().getPlaceholder());
        });
        if (log.isErrorEnabled()) {
            log.debug("erase cost {}ms  by field permission", (Object)(System.currentTimeMillis() - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeByTargetBusiness(String businessObjectCode, String businessOperationCode, @NotNull Supplier<T> executor) {
        BusinessContext parentContext = (BusinessContext)BUSINESS_CONTEXT.get();
        BUSINESS_CONTEXT.set(new BusinessContext(businessObjectCode, businessOperationCode));
        try {
            T t = executor.get();
            return t;
        }
        finally {
            if (parentContext == null) {
                BUSINESS_CONTEXT.remove();
            } else {
                BUSINESS_CONTEXT.set(parentContext);
            }
        }
    }

    public static SysDprRoleApiRowColumnRuleDTO getDataPermission() {
        return DataSecurityUtil.queryDataPermission();
    }

    public static SysDprRoleApiRowColumnRuleDTO getAllDataPermission() {
        return DataSecurityUtil.getRoleDataPermissionRuleService().getOriginalDataPermission();
    }

    public static List<SysDpcRoleApiFieldsDTO> getFieldPermission() {
        DataSecurityProperties prop = DataSecurityUtil.getDataSecurityProperties();
        if (Boolean.FALSE.equals(prop.getEnabled()) || Boolean.FALSE.equals(prop.getFieldPermission().getEnabled())) {
            log.info("field permission is disabled");
            return Collections.emptyList();
        }
        SysDprRoleApiRowColumnRuleDTO dataPermission = DataSecurityUtil.queryDataPermission();
        if (dataPermission == null || CollUtil.isEmpty((Collection)dataPermission.getSysDpcRoleApiFieldsDTOList())) {
            return Collections.emptyList();
        }
        boolean conflictShow = Boolean.TRUE.equals(DataSecurityUtil.getDataSecurityProperties().getConflictShow());
        return new ArrayList<SysDpcRoleApiFieldsDTO>(dataPermission.getSysDpcRoleApiFieldsDTOList().stream().collect(Collectors.toMap(SysDpcRoleApiFieldsDTO::getFieldName, Function.identity(), (t1, t2) -> {
            if (conflictShow) {
                if (Boolean.TRUE.equals(t1.getReadable())) {
                    if (Boolean.TRUE.equals(t2.getReadable())) {
                        return Boolean.TRUE.equals(t1.getWriteable()) ? t1 : t2;
                    }
                    return t1;
                }
                return Boolean.TRUE.equals(t2.getReadable()) ? t2 : t1;
            }
            if (Boolean.FALSE.equals(t1.getReadable())) {
                if (Boolean.FALSE.equals(t2.getReadable())) {
                    return Boolean.FALSE.equals(t1.getWriteable()) ? t1 : t2;
                }
                return t1;
            }
            return Boolean.FALSE.equals(t2.getReadable()) ? t2 : t1;
        })).values());
    }

    public static DprRuleRelationEnum getRelation(List<SysDprRoleApiDataRuleListQueryDTO> ruleList) {
        DprRuleRelationEnum relation = null;
        for (SysDprRoleApiDataRuleListQueryDTO rule : ruleList) {
            if (Boolean.TRUE.equals(rule.getRuleGroup())) continue;
            relation = DprRuleRelationEnum.valueOf(rule.getDprRuleRelation());
            break;
        }
        if (relation == null) {
            relation = DprRuleRelationEnum.DPR_RULE_RELATION_AND;
        }
        return relation;
    }

    private static SysDprRoleApiRowColumnRuleDTO queryDataPermission() {
        String businessObjectCode = null;
        String businessOperationCode = null;
        BusinessContext businessContext = (BusinessContext)BUSINESS_CONTEXT.get();
        if (businessContext != null) {
            businessObjectCode = businessContext.businessObjectCode;
            businessOperationCode = businessContext.businessOperationCode;
        }
        RoleDataPermissionRuleService service = DataSecurityUtil.getRoleDataPermissionRuleService();
        if (StringUtils.hasText((String)businessObjectCode) || StringUtils.hasText((String)businessOperationCode)) {
            SysDprRoleApiRowColumnRuleDTO dataPermission = service.getOriginalDataPermission();
            if (dataPermission == null) {
                return null;
            }
            return service.matchDataPermission(dataPermission, businessObjectCode, businessOperationCode);
        }
        return service.getMatchedDataPermission();
    }

    private static void eraseObjectValue(@NotNull Object data, @NotEmpty Set<String> eraseFieldNames, String placeholder) {
        ConfigurablePropertyAccessor propertyAccessor = PropertyAccessorFactory.forDirectFieldAccess((Object)data);
        Class fieldType = null;
        Object value = null;
        for (String fieldName : eraseFieldNames) {
            if (CharSequenceUtil.isBlank((CharSequence)fieldName)) continue;
            try {
                fieldType = propertyAccessor.getPropertyType(fieldName);
                if (fieldType == null) {
                    log.warn("{}.{}\u4e0d\u5b58\u5728\uff0c\u5c06\u5ffd\u7565", (Object)data.getClass().getName(), (Object)fieldName);
                    continue;
                }
                value = DataSecurityUtil.eraseValue(fieldType, placeholder);
                propertyAccessor.setPropertyValue(fieldName, value);
            }
            catch (BeansException e) {
                log.warn("\u6570\u636e\u6743\u9650\u6e05\u6d17{}.{}\u5931\u8d25\uff1a", new Object[]{data.getClass().getName(), fieldName, e});
            }
        }
    }

    private static Set<String> getUnreadableFieldsByExtension(Object bean, Set<String> fieldNames) {
        HashSet<String> result = new HashSet<String>();
        Set<String> tempFieldNames = null;
        for (FieldPermissionExtension extension : DataSecurityUtil.getFieldPermissionExtensions()) {
            try {
                tempFieldNames = extension.getUnreadableFields(bean, fieldNames);
            }
            catch (Exception e) {
                log.error("{}\u83b7\u53d6\u4e0d\u53ef\u8bfb\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38\uff1a", (Object)extension.getClass().getName(), (Object)e);
                continue;
            }
            if (!CollUtil.isNotEmpty(tempFieldNames)) continue;
            result.addAll(tempFieldNames);
        }
        return result;
    }

    private static Set<String> getUnreadableFields() {
        List<SysDpcRoleApiFieldsDTO> fields = DataSecurityUtil.getFieldPermission();
        if (fields.isEmpty()) {
            return Collections.emptySet();
        }
        return fields.stream().filter(t -> Boolean.FALSE.equals(t.getReadable())).map(SysDpcRoleApiFieldsDTO::getFieldName).collect(Collectors.toSet());
    }

    private static Object eraseValue(@NotNull Class<?> type, String placeholder) {
        if (String.class.isAssignableFrom(type)) {
            return CharSequenceUtil.blankToDefault((CharSequence)placeholder, null);
        }
        if (!type.isPrimitive()) {
            return null;
        }
        if (type.equals(Byte.TYPE)) {
            return 0;
        }
        if (type.equals(Short.TYPE)) {
            return 0;
        }
        if (type.equals(Integer.TYPE)) {
            return 0;
        }
        if (type.equals(Long.TYPE)) {
            return 0;
        }
        if (type.equals(Float.TYPE)) {
            return 0;
        }
        if (type.equals(Double.TYPE)) {
            return 0;
        }
        if (type.equals(Character.TYPE)) {
            return 0;
        }
        if (type.equals(Boolean.TYPE)) {
            return false;
        }
        return null;
    }

    private static Predicate getAuthJpaPredicate(SysDprRoleApiRowColumnRuleDTO userRoleDpr, Class<?> entityClass, String alias, String[] ruleFieldName) {
        List ruleList;
        List list = ruleList = userRoleDpr == null ? Collections.emptyList() : userRoleDpr.getSysDprRoleApiDataRuleListQueryDTO();
        if (ruleList.isEmpty()) {
            log.info("\u6ca1\u6709\u627e\u5230\u5f53\u524d\u7528\u6237\u6570\u636e\u6743\u9650\u914d\u7f6e-\u8df3\u8fc7\u6570\u636e\u6743\u9650");
            return new BooleanBuilder(null);
        }
        if (ArrayUtil.isNotEmpty((Object[])ruleFieldName)) {
            List<String> ruleFieldNameList = Arrays.asList(ruleFieldName);
            ruleList = ruleList.stream().filter(dpr -> CharSequenceUtil.isNotBlank((CharSequence)dpr.getDprRuleField()) && ruleFieldNameList.contains(dpr.getDprRuleField())).collect(Collectors.toList());
        }
        if (ruleList.isEmpty()) {
            log.info("\u6ca1\u6709\u627e\u5230\u5f53\u524d\u7528\u6237\u6570\u636e\u6743\u9650\u914d\u7f6e\u5339\u914d\u89c4\u5219-\u8df3\u8fc7\u6570\u636e\u6743\u9650");
            return new BooleanBuilder(null);
        }
        PathBuilder entityPath = new PathBuilder(entityClass, alias);
        Map<String, List<SysDprRoleApiDataRuleListQueryDTO>> groupMap = ruleList.stream().collect(Collectors.groupingBy(BaseDataSecurityRuleDTO::getRoleCode));
        ArrayList<Predicate> groupPredicates = new ArrayList<Predicate>();
        Predicate predicate = null;
        for (Map.Entry<String, List<SysDprRoleApiDataRuleListQueryDTO>> entry : groupMap.entrySet()) {
            DprRuleRelationEnum relation = DataSecurityUtil.getRelation(entry.getValue());
            predicate = DataSecurityUtil.buildPredicate(entry.getValue(), relation, entityPath);
            if (predicate == null) continue;
            groupPredicates.add(predicate);
        }
        return ExpressionUtils.anyOf(groupPredicates);
    }

    private static Predicate buildPredicate(List<SysDprRoleApiDataRuleListQueryDTO> ruleList, DprRuleRelationEnum relation, PathBuilder<?> entityPath) {
        if (CollUtil.isEmpty(ruleList)) {
            return null;
        }
        ArrayList<Predicate> predicateList = new ArrayList<Predicate>(ruleList.size());
        Predicate predicate = null;
        for (SysDprRoleApiDataRuleListQueryDTO rule : ruleList) {
            if (Boolean.TRUE.equals(rule.getRuleGroup())) {
                predicate = DataSecurityUtil.buildPredicate(rule.getGroupRules(), DprRuleRelationEnum.valueOf(rule.getDprRuleRelation()), entityPath);
                if (predicate == null) continue;
                predicateList.add(predicate);
                continue;
            }
            if (ReflectionUtil.getField((Class)entityPath.getType(), (String)rule.getDprRuleField()) == null) continue;
            predicate = RuleStrategyManager.getPathAutomatically(entityPath, rule);
            predicateList.add(predicate);
        }
        return relation == DprRuleRelationEnum.DPR_RULE_RELATION_OR ? ExpressionUtils.anyOf(predicateList) : ExpressionUtils.allOf(predicateList);
    }

    private static RoleDataPermissionRuleService getRoleDataPermissionRuleService() {
        if (roleDataPermissionRuleService == null) {
            roleDataPermissionRuleService = (RoleDataPermissionRuleService)SpringContextHolder.getBean(RoleDataPermissionRuleService.class);
        }
        return roleDataPermissionRuleService;
    }

    private static DataSecurityProperties getDataSecurityProperties() {
        if (dataSecurityProperties == null) {
            dataSecurityProperties = (DataSecurityProperties)SpringContextHolder.getBean(DataSecurityProperties.class);
        }
        return dataSecurityProperties;
    }

    private static List<FieldPermissionExtension> getFieldPermissionExtensions() {
        if (fieldPermissionExtensions == null) {
            fieldPermissionExtensions = SpringContextHolder.getObjectProvider(FieldPermissionExtension.class).stream().collect(Collectors.toList());
        }
        return fieldPermissionExtensions;
    }

    static {
        BUSINESS_CONTEXT = new InheritableThreadLocal();
    }

    private static class BusinessContext {
        private final String businessObjectCode;
        private final String businessOperationCode;

        public BusinessContext(String businessObjectCode, String businessOperationCode) {
            this.businessObjectCode = businessObjectCode;
            this.businessOperationCode = businessOperationCode;
        }
    }
}

