/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.dpr.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.auth.util.SecurityUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.common.constant.CompatibleModeEnum;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.boot.datasecurity.config.DataSecurityProperties;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleCacheService;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;
import com.elitescloud.boot.model.dto.SysBusinessParamDTO;
import com.elitescloud.boot.util.BusinessObjectUtil;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.DataPermissionType;
import com.elitescloud.cloudt.system.dto.BaseDataSecurityRuleDTO;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RoleDataPermissionRuleServiceImpl
implements RoleDataPermissionRuleService {
    private static final Logger logger = CloudtBootLoggerFactory.SECURITY_DATA.getLogger(RoleDataPermissionRuleServiceImpl.class);
    private final RoleDataPermissionRuleCacheService roleDataPermissionRuleCacheInterface;
    private final DataSecurityProperties properties;

    public RoleDataPermissionRuleServiceImpl(RoleDataPermissionRuleCacheService roleDataPermissionRuleCacheInterface, DataSecurityProperties properties) {
        this.roleDataPermissionRuleCacheInterface = roleDataPermissionRuleCacheInterface;
        this.properties = properties;
    }

    @Override
    public SysDprRoleApiRowColumnRuleDTO getMatchedDataPermission() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return null;
        }
        SysDprRoleApiRowColumnRuleDTO dataPermission = this.queryDataPermission(request);
        String businessObjectCode = this.obtainBusinessObjectCode(request);
        String businessOperationCode = this.obtainBusinessOperationCode(request);
        if (StringUtils.hasText((String)businessOperationCode) && CharSequenceUtil.isBlank((CharSequence)businessObjectCode)) {
            businessObjectCode = this.queryBusinessObjectCodeByBusinessOperationCode(businessOperationCode);
        }
        return this.matchDataPermission(dataPermission, businessObjectCode, businessOperationCode);
    }

    @Override
    public SysDprRoleApiRowColumnRuleDTO getOriginalDataPermission() {
        return this.queryDataPermission(HttpServletUtil.currentRequest());
    }

    @Override
    public SysDprRoleApiRowColumnRuleDTO matchDataPermission(SysDprRoleApiRowColumnRuleDTO ruleDTO, String businessObjectCode, String businessOperationCode) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null || Boolean.FALSE.equals(this.properties.getEnabled())) {
            return null;
        }
        if (ruleDTO == null) {
            ruleDTO = new SysDprRoleApiRowColumnRuleDTO();
        }
        if (StringUtils.hasText((String)businessObjectCode)) {
            businessObjectCode = businessObjectCode.contains(":") ? businessObjectCode.split(":")[0] : businessObjectCode;
        } else if (StringUtils.hasText((String)businessOperationCode)) {
            businessObjectCode = this.queryBusinessObjectCodeByBusinessOperationCode(businessOperationCode);
        }
        logger.info("start to match row rule...");
        if (CollUtil.isNotEmpty((Collection)ruleDTO.getSysDprRoleApiDataRuleListQueryDTO())) {
            ruleDTO.setSysDprRoleApiDataRuleListQueryDTO(this.filterRule(request, businessObjectCode, businessOperationCode, ruleDTO.getSysDprRoleApiDataRuleListQueryDTO()));
        }
        logger.info("start to match field rule...");
        if (Boolean.FALSE.equals(this.properties.getFieldPermission().getEnabled())) {
            ruleDTO.setSysDpcRoleApiFieldsDTOList(Collections.emptyList());
        } else {
            List<SysDpcRoleApiFieldsDTO> dprFields = CollUtil.isEmpty((Collection)ruleDTO.getSysDpcRoleApiFieldsDTOList()) ? Collections.emptyList() : this.filterRule(request, businessObjectCode, businessOperationCode, ruleDTO.getSysDpcRoleApiFieldsDTOList());
            ruleDTO.setSysDpcRoleApiFieldsDTOList(this.fillDprRoleApiFields(dprFields, businessObjectCode, businessOperationCode));
        }
        return ruleDTO;
    }

    private List<SysDpcRoleApiFieldsDTO> fillDprRoleApiFields(List<SysDpcRoleApiFieldsDTO> dprFields, String businessObjectCode, String businessOperationCode) {
        if (Boolean.TRUE.equals(this.properties.getDefaultAllow()) || StrUtil.isBlank((CharSequence)businessObjectCode)) {
            return dprFields;
        }
        List<SysBusinessParamDTO> allFields = this.roleDataPermissionRuleCacheInterface.getBusinessParams(businessObjectCode);
        if (CollUtil.isEmpty(allFields)) {
            return Collections.emptyList();
        }
        Map authFieldMap = CollUtil.isEmpty(dprFields) ? Collections.emptyMap() : dprFields.stream().collect(Collectors.toMap(SysDpcRoleApiFieldsDTO::getFieldName, t -> t, (t1, t2) -> t1));
        ArrayList<SysDpcRoleApiFieldsDTO> allFieldList = new ArrayList<SysDpcRoleApiFieldsDTO>(allFields.size());
        for (SysBusinessParamDTO allField : allFields) {
            SysDpcRoleApiFieldsDTO field = (SysDpcRoleApiFieldsDTO)authFieldMap.get(allField.getFieldName());
            if (field != null) {
                allFieldList.add(field);
                continue;
            }
            field = new SysDpcRoleApiFieldsDTO();
            field.setFieldName(allField.getFieldName());
            field.setReadable(Boolean.valueOf(false));
            field.setWriteable(Boolean.valueOf(false));
        }
        return allFieldList;
    }

    private SysDprRoleApiRowColumnRuleDTO queryDataPermission(HttpServletRequest request) {
        if (!this.supportDataPermission(request)) {
            logger.info("do not support data permission");
            return null;
        }
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        String token = SecurityContextUtil.currentToken();
        if (!StringUtils.hasText((String)token)) {
            logger.error("\u6570\u636e\u6743\u9650\uff1a\u83b7\u53d6Token\u4e3a\u7a7a ");
            SecurityUtil.throwUnauthorizedException();
            return null;
        }
        String cacheKey = token + "##" + ObjUtil.defaultIfNull((Object)user.getTenantId(), (Object)TenantConstant.DEFAULT_TENANT_ID) + "##" + ObjUtil.defaultIfNull((Object)user.getOrgId(), (Object)-1);
        SysDprRoleApiRowColumnRuleDTO rule = this.roleDataPermissionRuleCacheInterface.getDprFromLocalCache(cacheKey).orElseGet(() -> this.roleDataPermissionRuleCacheInterface.getDprFromRedisCache(cacheKey).orElseGet(() -> this.roleDataPermissionRuleCacheInterface.roleDataPermissionRuleRpc(cacheKey)));
        if (rule == null) {
            return null;
        }
        SysDprRoleApiRowColumnRuleDTO filteredRule = new SysDprRoleApiRowColumnRuleDTO();
        filteredRule.setUserId(rule.getUserId());
        filteredRule.setTenantId(rule.getTenantId());
        filteredRule.setTenantOrgId(rule.getTenantOrgId());
        filteredRule.setRoelIdList(rule.getRoelIdList());
        filteredRule.setRoleCodeList(rule.getRoleCodeList());
        this.normalizeRuleField(rule.getSysDprRoleApiDataRuleListQueryDTO());
        filteredRule.setSysDprRoleApiDataRuleListQueryDTO(rule.getSysDprRoleApiDataRuleListQueryDTO());
        filteredRule.setSysDpcRoleApiFieldsDTOList(Boolean.FALSE.equals(this.properties.getFieldPermission().getEnabled()) ? Collections.emptyList() : rule.getSysDpcRoleApiFieldsDTOList());
        return filteredRule;
    }

    private void normalizeRuleField(List<SysDprRoleApiDataRuleListQueryDTO> ruleList) {
        if (CollUtil.isEmpty(ruleList)) {
            return;
        }
        for (SysDprRoleApiDataRuleListQueryDTO rule : ruleList) {
            if (Boolean.TRUE.equals(rule.getRuleGroup())) {
                this.normalizeRuleField(rule.getGroupRules());
                continue;
            }
            rule.setDprRuleField(DataSecurityUtil.normalizeFieldName(rule.getDprRuleField()));
        }
    }

    private boolean supportDataPermission(HttpServletRequest request) {
        if (request == null) {
            logger.info("not a web request");
            return false;
        }
        if (Boolean.FALSE.equals(this.properties.getEnabled())) {
            logger.info("\u6570\u636e\u6743\u9650\u7981\u7528\uff1aelitesland.data-security=false");
            return false;
        }
        String uri = request.getRequestURI();
        if (uri.startsWith("/rpc")) {
            logger.info("rpc\u8c03\u7528\uff0c\u5ffd\u7565\u6570\u636e\u6743\u9650{} \uff1a{}", (Object)uri, (Object)"/rpc");
            return false;
        }
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        return user != null;
    }

    private <T extends BaseDataSecurityRuleDTO> List<T> filterRule(HttpServletRequest request, String businessObjectCode, String businessOperationCode, List<T> ruleList) {
        logger.info("businessObject:{}, businessObjectOperation:{}", (Object)businessObjectCode, (Object)businessOperationCode);
        List<T> filteredRuleList = this.filterByMenuOperation(ruleList, request, businessObjectCode, businessOperationCode);
        if (!filteredRuleList.isEmpty()) {
            logger.info("matched by MenuOperation");
            return filteredRuleList;
        }
        if (this.properties.getCompatible() == CompatibleModeEnum.OLDEST) {
            return Collections.emptyList();
        }
        if (CharSequenceUtil.isBlank((CharSequence)businessObjectCode)) {
            return Collections.emptyList();
        }
        filteredRuleList = this.filterByBusinessOperation(ruleList, request, businessObjectCode, businessOperationCode);
        if (!filteredRuleList.isEmpty()) {
            logger.info("matched by BusinessOperation");
            return filteredRuleList;
        }
        filteredRuleList = this.filterByBusinessObject(ruleList, businessObjectCode);
        if (!filteredRuleList.isEmpty()) {
            logger.info("matched by BusinessObject");
            return filteredRuleList;
        }
        logger.info("No permission rules were matched\uff1a{}", (Object)request.getRequestURI());
        return filteredRuleList;
    }

    private <T extends BaseDataSecurityRuleDTO> List<T> filterByMenuOperation(List<T> ruleList, HttpServletRequest request, String businessObjectCode, String businessOperationCode) {
        String menuCode = request.getHeader("menuCode");
        logger.info("menuCode\uff1a{}", (Object)menuCode);
        if (CharSequenceUtil.isBlank((CharSequence)menuCode)) {
            return Collections.emptyList();
        }
        CompatibleModeEnum compatible = this.properties.getCompatible();
        return ruleList.stream().filter(t -> {
            if (compatible == CompatibleModeEnum.OLDEST ? StringUtils.hasText((String)t.getPermissionType()) : compatible == CompatibleModeEnum.LATEST && !StringUtils.hasText((String)t.getPermissionType())) {
                return false;
            }
            if (!menuCode.equals(t.getMenusCode())) {
                return false;
            }
            if (StringUtils.hasText((String)t.getPermissionType())) {
                if (!DataPermissionType.MENU_OPERATION_RULE.name().equals(t.getPermissionType())) {
                    return false;
                }
                if (!t.getBusinessObjectCode().equals(businessObjectCode)) {
                    return false;
                }
                if (CharSequenceUtil.isBlank((CharSequence)businessOperationCode)) {
                    return false;
                }
            }
            return this.isMatchRequestForOperation(t, request, businessOperationCode);
        }).collect(Collectors.toList());
    }

    private <T extends BaseDataSecurityRuleDTO> List<T> filterByBusinessOperation(List<T> ruleList, HttpServletRequest request, String businessObjectCode, String businessOperationCode) {
        if (!StringUtils.hasText((String)businessObjectCode)) {
            return Collections.emptyList();
        }
        return ruleList.stream().filter(t -> {
            if (!DataPermissionType.BUSINESS_OPERATION_RULE.name().equals(t.getPermissionType())) {
                return false;
            }
            if (!businessObjectCode.equals(t.getBusinessObjectCode())) {
                return false;
            }
            return this.isMatchRequestForOperation(t, request, businessOperationCode);
        }).collect(Collectors.toList());
    }

    private <T extends BaseDataSecurityRuleDTO> List<T> filterByBusinessObject(List<T> ruleList, String businessObjectCode) {
        if (!StringUtils.hasText((String)businessObjectCode)) {
            return Collections.emptyList();
        }
        return ruleList.stream().filter(t -> {
            if (!DataPermissionType.BUSINESS_OBJECT_RULE.name().equals(t.getPermissionType())) {
                return false;
            }
            return businessObjectCode.equals(t.getBusinessObjectCode());
        }).collect(Collectors.toList());
    }

    private String queryBusinessObjectCodeByBusinessOperationCode(String businessOperationCode) {
        SysBusinessOperationDTO businessOperation = this.roleDataPermissionRuleCacheInterface.getBusinessOperationByBusinessOperationCode(businessOperationCode);
        Assert.notNull((Object)businessOperation, (String)("\u4e1a\u52a1\u64cd\u4f5c[" + businessOperationCode + "]\u4e0d\u5b58\u5728"));
        return businessOperation.getBusinessObjectCode();
    }

    private String obtainBusinessObjectCode(HttpServletRequest request) {
        return BusinessObjectUtil.obtainBusinessObjectCode((HttpServletRequest)request);
    }

    private String obtainBusinessOperationCode(HttpServletRequest request) {
        return BusinessObjectUtil.obtainBusinessOperationCode((HttpServletRequest)request);
    }

    private <T extends BaseDataSecurityRuleDTO> boolean isMatchRequestForOperation(@NotNull T rule, @NotNull HttpServletRequest request, String operationCode) {
        String apiCode = request.getHeader("apiCode");
        if (StringUtils.hasText((String)apiCode)) {
            return apiCode.equals(rule.getApiPermissionCode());
        }
        if (rule.getApiPermissionCode().equals(operationCode)) {
            return true;
        }
        if (!request.getMethod().equalsIgnoreCase(rule.getApiPermissionRequestType())) {
            return false;
        }
        String uri = request.getRequestURI();
        Map pathVariables = HttpServletUtil.getPathVariables((HttpServletRequest)request);
        if (pathVariables.isEmpty()) {
            return uri.equals(rule.getApiPermissionPath());
        }
        String path = StringUtils.hasText((String)rule.getPermissionType()) ? StrUtil.format((CharSequence)rule.getApiPermissionPath(), (Map)pathVariables) : MessageFormat.format(rule.getApiPermissionPath(), pathVariables.values());
        return uri.equals(path);
    }
}

